/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.config;

import com.exlibris.core.infra.common.exceptions.InfraException;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.interfaces.Resettable;
import com.exlibris.core.infra.model.codetables.HCodeTables;
import com.exlibris.core.infra.svc.api.CodeTablesManager;
import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.StringTokenizer;

public class InfraConfigurationManager
implements Resettable {
    private static final ExLogger log = ExLogger.getExLogger(InfraConfigurationManager.class);
    private static InfraConfigurationManager iRpc;
    private final Hashtable<String, String> locale2Lng = new Hashtable();
    private final Hashtable<String, String> lng2Locale = new Hashtable();
    protected final String LOCALE_CODES_FILE = "com.exlibris.dps.repository.localecodes";
    protected boolean isInit = false;

    protected InfraConfigurationManager() {
        this.infraLoad();
    }

    public static synchronized InfraConfigurationManager getInstance() {
        if (iRpc == null) {
            iRpc = new InfraConfigurationManager();
        }
        return iRpc;
    }

    @Override
    public synchronized void reset() {
        this.infraLoad();
    }

    protected void infraLoad() {
        try {
            log.info("Infra Configuration Setting loading started.");
            this.hashLocale();
            this.isInit = true;
            log.info("Infra Configuration Setting Loaded");
        }
        catch (Throwable e) {
            String err = "Failed to load configuration: " + e.getMessage();
            log.error(err, e, new String[0]);
            this.isInit = false;
            throw new RuntimeException(err, e);
        }
    }

    public boolean isInit() {
        return this.isInit;
    }

    protected String getParameter(String module, String key) throws InfraException {
        GeneralParameterManager gpManager = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
        return gpManager.getParameter(module, key);
    }

    public boolean isDevelopmentMode() {
        return System.getProperty("os.name").indexOf("Win") >= 0;
    }

    private void hashLocale() {
        CodeTablesManager codeTablesManagerObj = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
        List<HCodeTables> langCodeTables = codeTablesManagerObj.findCodeTablesByTableName("UserLanguage", "CRS00");
        if (langCodeTables == null || langCodeTables.size() == 0) {
            log.error("UserLanguage codetable not found or empty.", new String[0]);
            this.lng2Locale.put("English", "en");
            this.locale2Lng.put("en", "English");
        } else {
            for (HCodeTables codeTable : langCodeTables) {
                this.lng2Locale.put(codeTable.getDescription(), codeTable.getCode());
                this.locale2Lng.put(codeTable.getCode(), codeTable.getDescription());
            }
        }
    }

    public String getLocale(String lng) {
        return this.lng2Locale.get(lng);
    }

    public String getLanguage(String locale) {
        if (locale != null && locale.length() > 2) {
            locale = locale.substring(0, 2);
        }
        return this.locale2Lng.get(locale);
    }

    public List getLocales(String module) {
        String locales = "";
        try {
            locales = this.getParameter(module, "locales");
        }
        catch (InfraException infraException) {
            // empty catch block
        }
        ArrayList<Object> ar = new ArrayList<Object>();
        if (locales == null || locales.length() == 0) {
            ar.add("en");
            return ar;
        }
        StringTokenizer st = new StringTokenizer(locales);
        while (st.hasMoreElements()) {
            ar.add(st.nextElement());
        }
        return ar;
    }

    public boolean isMonolingual(String module) {
        return this.getLocales(module).size() == 1;
    }

    public boolean checkBooleanParameter(String module, String key) throws InfraException {
        String value = this.getParameter(module, key);
        return "true".equals(value);
    }
}

