/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.database.sqlcommand;

import com.exlibris.core.infra.svc.api.database.JDBCUtils;
import com.exlibris.core.infra.svc.api.database.sqlcommand.AbstractSQLCommand;
import com.exlibris.core.infra.svc.api.database.sqlcommand.SQLCommandBean;
import com.exlibris.core.infra.svc.api.database.sqlcommand.SQLCommandResults;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.xml.parsers.ParserConfigurationException;

public class TableSpacesInformationSQLCommand
extends AbstractSQLCommand {
    @Override
    public SQLCommandResults execute(SQLCommandBean commandBean) throws SQLException {
        String query = "SELECT d.tablespace_name ts_name,\nROUND(a.bytes/1024/1024/1024,2) overall_size,\nROUND((a.bytes - NVL(f.bytes, 0))/1024/1024/1024,2) used_gb,\nROUND(NVL(f.bytes, 0)/1024/1024/1024,2) free_gb,\nROUND(NVL((a.bytes -\nNVL(f.bytes, 0)) / a.bytes * 100, 0), 2) pct_used\nFROM sys.dba_tablespaces d,\n(select tablespace_name, sum(bytes) bytes \nfrom dba_data_files \ngroup by tablespace_name) a,\n(select tablespace_name, sum(bytes) bytes \nfrom dba_free_space \ngroup by tablespace_name) f\nWHERE d.tablespace_name = a.tablespace_name(+)\nAND d.tablespace_name = f.tablespace_name(+)\nAND NOT (d.extent_management like 'LOCAL' AND d.contents like 'TEMPORARY')\nUNION ALL\nSELECT  d.tablespace_name,\nround(a.bytes/1024/1024/1024,2) sizeg,\nround(t.bytes/1024/1024/1024,2) usedG,\nround((a.bytes/1024/1024/1024-t.bytes/1024/1024/1024),2) free ,\nROUND(NVL(t.bytes / a.bytes * 100, 0), 2) \"Used %\"\nFROM    sys.dba_tablespaces d,\n(select tablespace_name, sum(bytes) bytes\nfrom dba_temp_files\ngroup by tablespace_name) a,\n(select tablespace_name, sum(bytes_cached) bytes\nfrom v$temp_extent_pool group by tablespace_name) t\nWHERE   d.tablespace_name = a.tablespace_name(+)\nAND     d.tablespace_name = t.tablespace_name(+)\nAND     d.extent_management like 'LOCAL' AND d.contents like 'TEMPORARY'";
        String orderBy = commandBean.getParams().getOrderBy();
        Statement stmt = commandBean.getConnection().createStatement();
        if (orderBy != null && !orderBy.equals("")) {
            query = query + " order by " + orderBy;
        }
        ResultSet rs = stmt.executeQuery(query);
        SQLCommandResults results = new SQLCommandResults();
        try {
            results.setResults(JDBCUtils.toDocument(rs));
        }
        catch (ParserConfigurationException e) {
            results.setSuccess(false);
            results.setResults(null);
            return results;
        }
        results.setSuccess(true);
        return results;
    }
}

