/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.queue;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.model.resourcemanager.SipProcessingWorkMessage;
import com.exlibris.core.infra.svc.api.queue.QueueConstants;
import com.exlibris.core.infra.svc.api.queue.WorkQueue;
import com.exlibris.core.infra.svc.api.queue.WorkQueueApplicationException;
import com.exlibris.core.infra.svc.api.queue.WorkQueueFactory;
import java.util.AbstractMap;
import java.util.LinkedHashMap;
import java.util.TreeMap;

public class EnqueueHelper {
    private static final ExLogger log = ExLogger.getExLogger(EnqueueHelper.class, "DEP");

    public static void enqueueSipProcessingMessage(Long sipId, Long processId, String transitionName, String nodeName, int priority) {
        try {
            SipProcessingWorkMessage message = new SipProcessingWorkMessage();
            WorkQueueFactory workQueueFactory = WorkQueueFactory.getWorkQueueFactory(SipProcessingWorkMessage.class);
            WorkQueue workQueue = workQueueFactory.getWorkQueue("SIP_PROCESSING_QUEUE");
            message.setSipId(sipId);
            message.setTransitionName(transitionName);
            message.setProcessInstanceId(processId);
            message.setNodeName(nodeName);
            workQueue.enqueue(message, "sipID", sipId.toString(), priority, QueueConstants.messageType.QUEUE);
        }
        catch (WorkQueueApplicationException e) {
            log.error("Failed to enqueue sip to sipProcessingWorkQueue", e, sipId.toString());
        }
    }

    public static void enqueueRipAndPlanProcessingMessage(AbstractMap<String, String> message, Long uniqueId, String paramName, Long processId, String transitionName, String nodeName, int priority, String queueName, String operation) {
        try {
            message.put("uniqueId", uniqueId.toString());
            message.put("SPECIFIC_OPERATION", operation);
            message.put("nodeName", nodeName);
            message.put("processId", processId.toString());
            message.put("transitionName", transitionName);
            WorkQueue workQueue = null;
            if (queueName.equals("GENERIC_REP_Q")) {
                WorkQueueFactory workQueueFactory = WorkQueueFactory.getWorkQueueFactory(LinkedHashMap.class);
                workQueue = workQueueFactory.getWorkQueue(queueName);
            } else if (queueName.equals("GENERIC_PRSRV_Q")) {
                WorkQueueFactory workQueueFactory = WorkQueueFactory.getWorkQueueFactory(TreeMap.class);
                workQueue = workQueueFactory.getWorkQueue(queueName);
            }
            workQueue.enqueue(message, paramName, uniqueId.toString(), priority, QueueConstants.messageType.QUEUE);
        }
        catch (WorkQueueApplicationException e) {
            log.error("Failed to enqueue rip to Rip Processing Work Queue", e, uniqueId.toString());
        }
    }
}

