/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.sharedsession;

import com.exlibris.core.infra.svc.api.sharedsession.SessionHelperCleaner;
import com.exlibris.core.infra.svc.api.sharedsession.SharedSessionHandler;
import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;

public class SessionHelper {
    private static final Logger logger = Logger.getLogger(SessionHelper.class);
    public static final String EXL_SESS_CONTENT = "EXL_SESS_CONTENT";
    public static final String EXL_SESS_FINALIZER = "EXL_SESS_FINALIZER";
    public static final String EXL_SESS_LOGIN = "EXL_SESS_LOGIN";
    static Map<String, WeakReference<SharedSession>> sharedSessions = new ConcurrentHashMap<String, WeakReference<SharedSession>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SharedSession addSession(HttpSession session) {
        if (session != null) {
            String path;
            String id = session.getId();
            SharedSession sSession = null;
            WeakReference<SharedSession> weakReference = sharedSessions.get(id);
            if (weakReference != null) {
                sSession = (SharedSession)weakReference.get();
            }
            if (sSession == null) {
                Map<String, WeakReference<SharedSession>> map = sharedSessions;
                synchronized (map) {
                    weakReference = sharedSessions.get(id);
                    if (weakReference != null) {
                        sSession = (SharedSession)weakReference.get();
                    }
                    if (weakReference != null) {
                        sSession = (SharedSession)weakReference.get();
                    }
                    if (sSession == null) {
                        sSession = (SharedSession)session.getAttribute(EXL_SESS_CONTENT);
                        if (sSession == null) {
                            sSession = new SharedSession();
                            sSession.id = id;
                        }
                        sharedSessions.put(id, new WeakReference<SharedSession>(sSession));
                    }
                }
            }
            if (!sSession.sessionContexts.contains(path = session.getServletContext().getContextPath())) {
                sSession.sessions.put(path, session);
                sSession.sessionContexts.add(path);
                session.setAttribute(EXL_SESS_CONTENT, (Object)sSession);
            }
            sSession.lastUse = System.currentTimeMillis();
            return sSession;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeSession(HttpSession session) {
        if (session != null) {
            String id = session.getId();
            SharedSession sSession = null;
            WeakReference<SharedSession> weakReference = sharedSessions.get(id);
            if (weakReference != null) {
                sSession = (SharedSession)weakReference.get();
            }
            if (sSession != null) {
                Set<String> set = sSession.sessionContexts;
                synchronized (set) {
                    logger.log((Priority)Level.INFO, (Object)(id + " '" + session.getServletContext().getContextPath() + "' removed."));
                    sSession.sessionContexts.remove(session.getServletContext().getContextPath());
                    if (sSession.sessionContexts.size() == 0) {
                        Map<String, WeakReference<SharedSession>> map = sharedSessions;
                        synchronized (map) {
                            logger.log((Priority)Level.INFO, (Object)(id + " removed."));
                            sharedSessions.remove(id);
                            SharedSessionHandler finalizer = (SharedSessionHandler)sSession.attributes.get(EXL_SESS_FINALIZER);
                            if (finalizer != null) {
                                finalizer.sharedSessionDestroyed();
                            }
                        }
                    }
                }
            }
        }
    }

    public static void invalidateAllSessions(HttpSession session) {
        if (session != null) {
            String id = session.getId();
            session.invalidate();
            SharedSession sSession = null;
            WeakReference<SharedSession> weakReference = sharedSessions.get(id);
            if (weakReference != null) {
                sSession = (SharedSession)weakReference.get();
            }
            if (sSession != null && sSession.sessionContexts != null) {
                for (Object path : sSession.sessionContexts.toArray()) {
                    HttpSession session2 = sSession.sessions.get(path);
                    if (session2 == null) continue;
                    try {
                        session2.invalidate();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    public static void setAttribute(HttpServletRequest request, String attName, Object attValue) {
        SharedSession sSession;
        HttpSession session = null;
        try {
            session = request.getSession();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (request != null && session != null && (sSession = SessionHelper.addSession(session)) != null) {
            sSession.lastUse = System.currentTimeMillis();
            if (attValue == null) {
                sSession.attributes.remove(attName);
                session.removeAttribute(attName);
            } else {
                sSession.attributes.put(attName, attValue);
                session.setAttribute(attName, attValue);
            }
        }
    }

    public static Object getAttribute(HttpServletRequest request, String attName) {
        SharedSession sSession;
        HttpSession session = null;
        try {
            session = request.getSession();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (request != null && session != null && (sSession = SessionHelper.addSession(session)) != null) {
            sSession.lastUse = System.currentTimeMillis();
            return sSession.attributes.get(attName);
        }
        return null;
    }

    public static boolean isPresent(String exlSessId) {
        return sharedSessions.get(exlSessId) != null;
    }

    public static Map<String, WeakReference<SharedSession>> getSharedSessions() {
        return sharedSessions;
    }

    static {
        SessionHelperCleaner.start();
    }

    public static class SharedSession
    implements Serializable {
        private static final long serialVersionUID = -1433481655597319244L;
        public String id;
        public Map<String, Object> attributes = new ConcurrentHashMap<String, Object>();
        public Set<String> sessionContexts = new HashSet<String>();
        public transient Map<String, HttpSession> sessions = new ConcurrentHashMap<String, HttpSession>();
        public volatile long lastUse;
        public long create = System.currentTimeMillis();

        public SharedSession() {
            this.lastUse = System.currentTimeMillis();
        }
    }
}

