/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.dps.sdk.mets;

import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.digitool.exceptions.DigitoolException;
import com.exlibris.dps.sdk.mets.FileData;
import gov.loc.mets.DivType;
import gov.loc.mets.FileType;
import gov.loc.mets.MdSecType;
import gov.loc.mets.MetsDocument;
import gov.loc.mets.MetsType;
import gov.loc.mets.StructMapType;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Calendar;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.dom4j.InvalidXPathException;
import org.dom4j.Node;

public class DpsMetsProfile {
    public static final String GROUP_ID_PREFIX = "gid";
    public static final String STRUCT_MAP_TYPE = "PHYSICAL";
    public static final String DIV1_LABEL = "collection";
    public static final String DEFAULT_USAGE_TYPE = "view";
    public static final String DEFAULT_PRESERVATION_LEVEL = "master";
    public static final String DC_IDENTIFIER = "dc:identifier";
    public static final String DC_TITLE = "dc:title";
    public static final String DMDSEC_ID_PREFIX = "DMD";
    public static final String FILE_ID_PREFIX = "_id";
    public static final String CHECKSUM_TYPE = "MD5";
    private MetsDocument internalDocument;
    private int fileGroupCounter;
    private int fileCounter;
    private int dcIdentifierCounter;
    private int recordCounter;

    protected DpsMetsProfile(MetsDocument metsDoc) {
        this.internalDocument = metsDoc;
        this.fileGroupCounter = 0;
        this.fileCounter = 0;
        this.dcIdentifierCounter = 0;
        this.recordCounter = 0;
    }

    public void addDc(Node dc) throws DigitoolException {
        XmlObject xmlObject = null;
        try {
            xmlObject = XmlObject.Factory.parse((String)dc.asXML());
        }
        catch (XmlException e) {
            throw new DigitoolException(DescriptorConstants.DP_FailedToParseDcXml);
        }
        this.internalDocument.getMets().addNewDmdSec().addNewMdWrap().addNewXmlData().set(xmlObject);
    }

    public MetsType.FileSec.FileGrp addNewFileGrp(String usageType, String preservationLevel, String groupId) {
        ++this.fileGroupCounter;
        this.fileCounter = 0;
        if (groupId == null || groupId.trim().equals("")) {
            groupId = GROUP_ID_PREFIX + this.fileGroupCounter;
        }
        StructMapType structMap = this.internalDocument.getMets().addNewStructMap();
        structMap.setTYPE(STRUCT_MAP_TYPE);
        structMap.setID(groupId);
        this.internalDocument.getMets().getStructMapArray(this.fileGroupCounter - 1).addNewDiv().setLABEL(DIV1_LABEL);
        if (!this.internalDocument.getMets().isSetFileSec()) {
            this.internalDocument.getMets().addNewFileSec();
        }
        MetsType.FileSec.FileGrp fileGrp = this.internalDocument.getMets().getFileSec().addNewFileGrp();
        if (usageType == null || usageType.trim().equals("")) {
            usageType = DEFAULT_USAGE_TYPE;
        }
        if (preservationLevel == null || preservationLevel.trim() == "") {
            preservationLevel = DEFAULT_PRESERVATION_LEVEL;
        }
        fileGrp.setID(groupId);
        return fileGrp;
    }

    public FileType addNewFile2FileGrp(FileData fileData) throws IOException, DigitoolException {
        String label;
        Node dc = fileData.getDc();
        MetsType.FileSec.FileGrp fileGrp = fileData.getFileGrp();
        String groupId = fileData.getGroupId();
        String id = fileData.getGroupId();
        Calendar created = fileData.getCreated();
        String mimeType = fileData.getMimeType();
        Integer seq = fileData.getSeq();
        String checksum = fileData.getChecksum();
        FileType.CHECKSUMTYPE.Enum checksumType = fileData.getChecksumType();
        boolean generateChecksum = fileData.isGenerateChecksum();
        long size = fileData.getSize();
        FileType.FLocat.LOCTYPE.Enum locType = fileData.getLocType();
        String xlinkHref = fileData.getXlinkHref();
        String absoluteLink = fileData.getAbsoluteLink();
        ++this.fileCounter;
        try {
            label = dc.selectSingleNode(DC_IDENTIFIER).getText();
            if (label == null || label.trim().equals("")) {
                label = dc.selectSingleNode(DC_TITLE).getText();
            }
        }
        catch (InvalidXPathException e) {
            label = "";
        }
        if (this.dcIdentifierCounter == 0) {
            this.dcIdentifierCounter = dc.selectNodes(DC_IDENTIFIER).size();
            this.internalDocument.getMets().getStructMapArray(this.fileGroupCounter - 1).getDiv().addNewDiv().setLABEL(label);
            --this.dcIdentifierCounter;
            ++this.recordCounter;
        }
        DivType div = this.internalDocument.getMets().getStructMapArray(this.fileGroupCounter - 1).getDiv().getDivArray(this.recordCounter - 1).addNewDiv();
        div.setLABEL(label);
        MdSecType dmdSec = this.internalDocument.getMets().addNewDmdSec();
        String dmdId = DMDSEC_ID_PREFIX + this.fileCounter;
        dmdSec.setID(dmdId);
        XmlObject xmlObject = null;
        try {
            xmlObject = XmlObject.Factory.parse((String)dc.asXML());
        }
        catch (XmlException e) {
            throw new DigitoolException(DescriptorConstants.DP_FailedToParseDcXml);
        }
        MdSecType.MdWrap mdWrap = dmdSec.addNewMdWrap();
        mdWrap.addNewXmlData().set(xmlObject);
        mdWrap.setMDTYPE(MdSecType.MdWrap.MDTYPE.DC);
        FileType file = fileGrp.addNewFile();
        if (groupId == null || groupId.trim().equals("")) {
            groupId = GROUP_ID_PREFIX + this.fileGroupCounter;
        }
        file.setGROUPID(groupId);
        if (id == null || id.trim().equals("")) {
            id = groupId + FILE_ID_PREFIX + this.fileCounter;
        }
        file.setID(id);
        div.addNewFptr().setFILEID(id);
        ArrayList<String> listDmdId = new ArrayList<String>();
        listDmdId.add(0, dmdId);
        file.setDMDID(listDmdId);
        if (created == null) {
            created = Calendar.getInstance();
        }
        file.setCREATED(created);
        if (seq == 0) {
            seq = this.fileCounter;
        }
        file.setSEQ(seq);
        if (generateChecksum) {
            checksum = this.GenerateChecksum_MD5(absoluteLink);
            checksumType = FileType.CHECKSUMTYPE.MD_5;
        }
        file.setCHECKSUM(checksum);
        file.setCHECKSUMTYPE(checksumType);
        file.setSIZE(size);
        FileType.FLocat flocat = file.addNewFLocat();
        if (locType == null) {
            locType = FileType.FLocat.LOCTYPE.URL;
        }
        flocat.setLOCTYPE(locType);
        flocat.setHref(xlinkHref);
        return file;
    }

    public MetsDocument getInternalDocument() {
        return this.internalDocument;
    }

    private String GenerateChecksum_MD5(String absoluteLink) throws IOException {
        int offset;
        File inFile = new File(absoluteLink);
        FileInputStream is = new FileInputStream(inFile);
        long length = inFile.length();
        byte[] fbytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < fbytes.length && (numRead = ((InputStream)is).read(fbytes, offset, fbytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < fbytes.length) {
            throw new IOException("Could not completely read file " + inFile.getName());
        }
        ((InputStream)is).close();
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance(CHECKSUM_TYPE);
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        byte[] digest = md.digest(fbytes);
        StringBuffer hexString = new StringBuffer();
        for (int i = 0; i < digest.length; ++i) {
            String hex = Integer.toHexString(0xFF & digest[i]);
            if (hex.length() == 1) {
                hexString.append("0" + hex);
                continue;
            }
            hexString.append(hex);
        }
        return hexString.toString();
    }
}

