/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.dps.utils;

import com.exlibris.core.sdk.consts.Enum;
import com.exlibris.digitool.common.dnx.DnxDocumentHelper;
import com.exlibris.digitool.common.dnx.DnxRecordKey;
import com.exlibris.digitool.common.dnx.DnxSectionRecord;
import com.exlibris.repository.persistence.digitalentity.HDeMetadataRegistry;
import com.exlibris.repository.persistence.digitalentity.HDeStreamRef;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class MetadataUtils {
    public static final String STATUS = "status";
    private static Map<String, String> dnxXPaths = null;
    private static Map<String, String> dnxNamespaces = null;

    public static boolean isMdRelevantToObjectType(HDeMetadataRegistry mddao, Enum.ObjectType objectType2) {
        boolean isRelevant = false;
        switch (objectType2) {
            case INTELLECTUAL_ENTITY: {
                isRelevant = mddao.isRelevantToIE();
                break;
            }
            case REPRESENTATION: {
                isRelevant = mddao.isRelevantToRep();
                break;
            }
            case FILE: {
                isRelevant = mddao.isRelevantToFile();
                break;
            }
        }
        return isRelevant;
    }

    public static String getFileName(HDeStreamRef stream, DnxDocumentHelper.GeneralFileCharacteristics generalFileCharacteristics) {
        String originalFileName = stream.getFileName();
        if (StringUtils.isBlank((String)originalFileName)) {
            originalFileName = generalFileCharacteristics.getFileOriginalName();
        }
        if (StringUtils.isBlank((String)originalFileName)) {
            originalFileName = stream.getPid() + "." + stream.getFileExtension();
        }
        return originalFileName;
    }

    private static void initMaps() {
        if (dnxXPaths == null) {
            dnxXPaths = new HashMap<String, String>();
            dnxXPaths.put(STATUS, "/dnx/section[@id=\"generalIECharacteristics\"]/record/key[@id=\"status\"][1]");
        }
        if (dnxNamespaces == null) {
            dnxNamespaces = new HashMap<String, String>();
            dnxNamespaces.put(STATUS, "xmlns=\"http://www.exlibrisgroup.com/dps/dnx\"");
        }
    }

    public static String getDnxXPath(String key) {
        MetadataUtils.initMaps();
        return dnxXPaths.get(key);
    }

    public static String getDnxNamespaces(String key) {
        MetadataUtils.initMaps();
        return dnxNamespaces.get(key);
    }

    public static final Boolean isEqual(DnxSectionRecord dnx1, DnxSectionRecord dnx2) {
        String value2;
        String value1;
        List<DnxRecordKey> keyList1 = dnx1.getKeylist();
        List<DnxRecordKey> keyList2 = dnx2.getKeylist();
        for (DnxRecordKey key : keyList1) {
            value1 = dnx1.getSectionKeyValue(key.getId()) == null ? "" : dnx1.getSectionKeyValue(key.getId()).trim();
            if (value1.equals(value2 = dnx2.getSectionKeyValue(key.getId()) == null ? "" : dnx2.getSectionKeyValue(key.getId()).trim())) continue;
            return false;
        }
        for (DnxRecordKey key : keyList2) {
            value1 = dnx1.getSectionKeyValue(key.getId()) == null ? "" : dnx1.getSectionKeyValue(key.getId()).trim();
            if (value1.equals(value2 = dnx2.getSectionKeyValue(key.getId()) == null ? "" : dnx2.getSectionKeyValue(key.getId()).trim())) continue;
            return false;
        }
        return true;
    }
}

