/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.reader;

import gov.loc.repository.bagit.exceptions.InvalidBagitFileFormatException;
import gov.loc.repository.bagit.exceptions.MaliciousPathException;
import gov.loc.repository.bagit.util.PathUtils;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.helpers.MessageFormatter;

public interface TagFileReader {
    public static final Logger logger = LoggerFactory.getLogger(TagFileReader.class);
    public static final ResourceBundle messages = ResourceBundle.getBundle("MessageBundle");
    public static final String ERROR_PREFIX = "Path [";

    public static Path createFileFromManifest(Path bagRootDir, String path) throws MaliciousPathException, InvalidBagitFileFormatException {
        Path file;
        String fixedPath = path;
        if (path.charAt(0) == '*') {
            logger.warn(messages.getString("removing_asterisk"));
            fixedPath = path.substring(1);
        }
        if (path.contains("\\")) {
            String formattedMessage = messages.getString("blackslash_used_as_path_separator_error");
            throw new InvalidBagitFileFormatException(MessageFormatter.format((String)formattedMessage, (Object)path).getMessage());
        }
        if (path.contains("~/")) {
            String formattedMessage = messages.getString("malicious_path_error");
            throw new MaliciousPathException(MessageFormatter.format((String)formattedMessage, (Object)path).getMessage());
        }
        if ((fixedPath = PathUtils.decodeFilname(fixedPath)).startsWith("file://")) {
            try {
                file = Paths.get(new URI(fixedPath));
            }
            catch (URISyntaxException e) {
                String formattedMessage = messages.getString("invalid_url_format_error");
                throw new InvalidBagitFileFormatException(MessageFormatter.format((String)formattedMessage, (Object)path).getMessage(), e);
            }
        } else {
            file = bagRootDir.resolve(fixedPath).normalize();
        }
        if (!file.normalize().startsWith(bagRootDir)) {
            String formattedMessage = messages.getString("malicious_path_error");
            throw new MaliciousPathException(MessageFormatter.format((String)formattedMessage, (Object)file).getMessage());
        }
        return file;
    }
}

