/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.serialize;

import java.util.Properties;
import net.sf.saxon.event.FilterFactory;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceNormalizer;
import net.sf.saxon.event.SequenceNormalizerWithItemSeparator;
import net.sf.saxon.event.SequenceNormalizerWithSpaceSeparator;
import net.sf.saxon.serialize.CharacterMapIndex;

public class SerializationProperties {
    Properties properties;
    CharacterMapIndex charMapIndex;
    FilterFactory validationFactory;

    public SerializationProperties() {
        this.properties = new Properties();
    }

    public SerializationProperties(Properties props) {
        this.properties = props;
    }

    public SerializationProperties(Properties props, CharacterMapIndex charMapIndex) {
        this.properties = props;
        this.charMapIndex = charMapIndex;
    }

    public void setProperty(String name, String value) {
        this.properties.setProperty(name, value);
    }

    public String getProperty(String name) {
        return this.getProperties().getProperty(name);
    }

    public Properties getProperties() {
        return this.properties;
    }

    public CharacterMapIndex getCharacterMapIndex() {
        return this.charMapIndex;
    }

    public void setValidationFactory(FilterFactory validationFactory) {
        this.validationFactory = validationFactory;
    }

    public FilterFactory getValidationFactory() {
        return this.validationFactory;
    }

    public SequenceNormalizer makeSequenceNormalizer(Receiver next) {
        String itemSeparator;
        if (this.getValidationFactory() != null) {
            next = this.getValidationFactory().makeFilter(next);
        }
        return (itemSeparator = this.properties.getProperty("item-separator")) == null || "#absent".equals(itemSeparator) ? new SequenceNormalizerWithSpaceSeparator(next) : new SequenceNormalizerWithItemSeparator(next, itemSeparator);
    }

    public SerializationProperties combineWith(SerializationProperties defaults) {
        FilterFactory validationFactory;
        CharacterMapIndex charMap = this.charMapIndex;
        if (charMap == null || charMap.isEmpty()) {
            charMap = defaults.getCharacterMapIndex();
        }
        if ((validationFactory = this.validationFactory) == null) {
            validationFactory = defaults.validationFactory;
        }
        Properties props = new Properties(defaults.getProperties());
        for (String prop : this.getProperties().stringPropertyNames()) {
            String value = this.getProperties().getProperty(prop);
            if (prop.equals("cdata-section-elements") || prop.equals("suppress-indentation")) {
                String existing = defaults.getProperty(prop);
                if (existing == null || existing.equals(value)) {
                    props.setProperty(prop, value);
                    continue;
                }
                props.setProperty(prop, existing + " " + value);
                continue;
            }
            props.setProperty(prop, value);
        }
        SerializationProperties newParams = new SerializationProperties(props, charMap);
        newParams.setValidationFactory(validationFactory);
        return newParams;
    }
}

