/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.decorator;

import java.awt.Color;
import java.awt.Component;
import org.jdesktop.swingx.color.ColorUtil;
import org.jdesktop.swingx.decorator.AbstractHighlighter;
import org.jdesktop.swingx.decorator.ComponentAdapter;
import org.jdesktop.swingx.decorator.HighlightPredicate;

public class ColorHighlighter
extends AbstractHighlighter {
    private Color background;
    private Color foreground;
    private Color selectedBackground;
    private Color selectedForeground;
    @Deprecated
    private boolean legacy;

    public ColorHighlighter() {
        this(null);
    }

    public ColorHighlighter(HighlightPredicate predicate) {
        this(predicate, null, null);
    }

    public ColorHighlighter(Color cellBackground, Color cellForeground) {
        this(null, cellBackground, cellForeground);
    }

    public ColorHighlighter(HighlightPredicate predicate, Color cellBackground, Color cellForeground) {
        this(predicate, cellBackground, cellForeground, null, null);
    }

    public ColorHighlighter(Color cellBackground, Color cellForeground, Color selectedBackground, Color selectedForeground) {
        this(null, cellBackground, cellForeground, selectedBackground, selectedForeground);
    }

    public ColorHighlighter(HighlightPredicate predicate, Color cellBackground, Color cellForeground, Color selectedBackground, Color selectedForeground) {
        super(predicate);
        this.background = cellBackground;
        this.foreground = cellForeground;
        this.selectedBackground = selectedBackground;
        this.selectedForeground = selectedForeground;
    }

    protected Component doHighlight(Component renderer, ComponentAdapter adapter) {
        this.applyBackground(renderer, adapter);
        this.applyForeground(renderer, adapter);
        return renderer;
    }

    protected void applyBackground(Component renderer, ComponentAdapter adapter) {
        Color color;
        Color color2 = color = adapter.isSelected() ? this.getSelectedBackground() : this.getBackground();
        if (this.isLegacy() && color != null) {
            renderer.setBackground(color);
        } else {
            renderer.setBackground(ColorUtil.blend(renderer.getBackground(), color));
        }
    }

    protected void applyForeground(Component renderer, ComponentAdapter adapter) {
        Color color;
        Color color2 = color = adapter.isSelected() ? this.getSelectedForeground() : this.getForeground();
        if (this.isLegacy() && color != null) {
            renderer.setForeground(color);
        } else {
            renderer.setForeground(ColorUtil.blend(renderer.getForeground(), color));
        }
    }

    public Color getBackground() {
        return this.background;
    }

    public void setBackground(Color color) {
        if (this.areEqual(color, this.getBackground())) {
            return;
        }
        this.background = color;
        this.fireStateChanged();
    }

    public Color getForeground() {
        return this.foreground;
    }

    public void setForeground(Color color) {
        if (this.areEqual(color, this.getForeground())) {
            return;
        }
        this.foreground = color;
        this.fireStateChanged();
    }

    public Color getSelectedBackground() {
        return this.selectedBackground;
    }

    public void setSelectedBackground(Color color) {
        if (this.areEqual(color, this.getSelectedBackground())) {
            return;
        }
        this.selectedBackground = color;
        this.fireStateChanged();
    }

    public Color getSelectedForeground() {
        return this.selectedForeground;
    }

    public void setSelectedForeground(Color color) {
        if (this.areEqual(color, this.getSelectedForeground())) {
            return;
        }
        this.selectedForeground = color;
        this.fireStateChanged();
    }

    @Deprecated
    public boolean isLegacy() {
        return this.legacy;
    }

    @Deprecated
    public void setLegacy(boolean legacy) {
        this.legacy = legacy;
        this.fireStateChanged();
    }
}

