/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.common;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderMalfunctionError;
import java.nio.charset.CoderResult;
import java.nio.charset.CodingErrorAction;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import org.jwat.common.Base64;
import org.jwat.common.QuotedPrintable;

public class EncodedWords {
    protected static final int S_START_EQ = 0;
    protected static final int S_START_QM = 1;
    protected static final int S_CHARSET = 2;
    protected static final int S_ENCODING = 3;
    protected static final int S_ENCODED_WORDS = 4;
    protected static final int S_END_EQ = 5;
    public static final int ENC_BASE64 = 1;
    public static final int ENC_QUOTEDPRINTABLE = 2;
    protected static final int CC_CONTROL = 1;
    protected static final int CC_SEPARATOR_WS = 2;
    protected static final String separators = "()<>@,;:\\\"/[]?={} \t";
    protected static final byte[] charCharacteristicsTab;
    public boolean bValidCharset;
    public String charsetStr;
    public int encoding;
    public String encodingStr;
    public String encoded_text;
    public boolean bConversionError;
    public String decoded_text;
    public byte[] line;
    public boolean bIsValid = false;

    public static EncodedWords parseEncodedWords(InputStream in, boolean bParseEqQm) throws IOException {
        EncodedWords ew = new EncodedWords();
        ByteArrayOutputStream lineOut = new ByteArrayOutputStream();
        StringBuffer sb = new StringBuffer();
        Charset charset = null;
        int state = bParseEqQm ? 0 : 2;
        boolean bLoop = true;
        while (bLoop) {
            int c = in.read();
            if (c != -1) {
                lineOut.write(c);
            }
            block2 : switch (state) {
                case 0: {
                    if (c == 61) {
                        state = 1;
                        break;
                    }
                    bLoop = false;
                    break;
                }
                case 1: {
                    if (c == 63) {
                        state = 2;
                        break;
                    }
                    bLoop = false;
                    break;
                }
                case 2: {
                    switch (c) {
                        case -1: 
                        case 10: 
                        case 13: {
                            bLoop = false;
                            break block2;
                        }
                        case 63: {
                            ew.charsetStr = sb.toString().toUpperCase();
                            sb.setLength(0);
                            if (ew.charsetStr.length() > 0) {
                                try {
                                    charset = Charset.forName(ew.charsetStr);
                                    ew.bValidCharset = true;
                                }
                                catch (IllegalCharsetNameException e) {
                                }
                                catch (UnsupportedCharsetException e) {
                                    // empty catch block
                                }
                                state = 3;
                                break block2;
                            }
                            bLoop = false;
                            break block2;
                        }
                    }
                    if (charCharacteristicsTab[c] == 0 && c < 127) {
                        sb.append((char)c);
                        break;
                    }
                    bLoop = false;
                    break;
                }
                case 3: {
                    switch (c) {
                        case -1: 
                        case 10: 
                        case 13: {
                            bLoop = false;
                            break block2;
                        }
                        case 63: {
                            ew.encodingStr = sb.toString().toUpperCase();
                            sb.setLength(0);
                            if (ew.encodingStr.length() > 0) {
                                if ("b".equalsIgnoreCase(ew.encodingStr)) {
                                    ew.encoding = 1;
                                } else if ("q".equalsIgnoreCase(ew.encodingStr)) {
                                    ew.encoding = 2;
                                }
                                state = 4;
                                break block2;
                            }
                            bLoop = false;
                            break block2;
                        }
                    }
                    if (charCharacteristicsTab[c] == 0 && c < 127) {
                        sb.append((char)c);
                        break;
                    }
                    bLoop = false;
                    break;
                }
                case 4: {
                    switch (c) {
                        case -1: 
                        case 10: 
                        case 13: {
                            bLoop = false;
                            break block2;
                        }
                        case 63: {
                            ew.encoded_text = sb.toString();
                            sb.setLength(0);
                            byte[] decoded = null;
                            if (ew.encoding == 1) {
                                decoded = Base64.decodeToArray(ew.encoded_text, true);
                            } else if (ew.encoding == 2) {
                                decoded = QuotedPrintable.decode(ew.encoded_text);
                            }
                            if (decoded != null) {
                                ByteBuffer bb = ByteBuffer.wrap(decoded);
                                CharBuffer cb = CharBuffer.allocate(bb.capacity());
                                CharsetDecoder decoder = charset.newDecoder();
                                decoder.onMalformedInput(CodingErrorAction.REPORT);
                                decoder.onUnmappableCharacter(CodingErrorAction.REPORT);
                                try {
                                    boolean bDecodeLoop = true;
                                    while (bDecodeLoop) {
                                        CoderResult result = decoder.decode(bb, cb, true);
                                        sb.append(cb.array(), cb.arrayOffset(), cb.position());
                                        cb.clear();
                                        if (result == CoderResult.UNDERFLOW) {
                                            bDecodeLoop = false;
                                            continue;
                                        }
                                        if (!result.isError()) continue;
                                        bb.position(Math.min(bb.position() + result.length(), bb.limit()));
                                        sb.append('?');
                                        ew.bConversionError = true;
                                    }
                                }
                                catch (CoderMalfunctionError e) {
                                    // empty catch block
                                }
                                ew.decoded_text = sb.toString();
                            }
                            state = 5;
                            break block2;
                        }
                    }
                    if (c > 32 && c < 127) {
                        sb.append((char)c);
                        break;
                    }
                    bLoop = false;
                    break;
                }
                case 5: {
                    if (c == -1) {
                        bLoop = false;
                        break;
                    }
                    if (c != 61) break;
                    ew.bIsValid = true;
                    bLoop = false;
                }
            }
        }
        ew.line = lineOut.toByteArray();
        ew.bIsValid = ew.bIsValid & ew.bValidCharset & ew.encoding != 0 && ew.decoded_text != null;
        return ew;
    }

    static {
        int i;
        charCharacteristicsTab = new byte[256];
        for (i = 0; i < separators.length(); ++i) {
            EncodedWords.charCharacteristicsTab[separators.charAt((int)i)] = 2;
        }
        for (i = 0; i < 32; ++i) {
            EncodedWords.charCharacteristicsTab[i] = 1;
        }
    }
}

