/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.arc;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.jwat.arc.ArcFieldParsers;
import org.jwat.arc.ArcHeader;
import org.jwat.arc.ArcReader;
import org.jwat.arc.ArcRecordBase;
import org.jwat.arc.ArcVersion;
import org.jwat.arc.ArcVersionHeader;
import org.jwat.arc.ArcWriter;
import org.jwat.common.ByteCountingPushBackInputStream;
import org.jwat.common.Diagnosis;
import org.jwat.common.DiagnosisType;
import org.jwat.common.Diagnostics;
import org.jwat.common.Payload;

public class ArcVersionBlock
extends ArcRecordBase {
    public static final int TOSTRING_BUFFER_SIZE = 256;

    protected ArcVersionBlock() {
    }

    public static ArcVersionBlock createRecord(ArcWriter writer) {
        ArcVersionBlock vb = new ArcVersionBlock();
        vb.trailingNewLines = 1;
        vb.diagnostics = new Diagnostics();
        vb.header = ArcHeader.initHeader(writer, vb.diagnostics);
        writer.fieldParsers.diagnostics = vb.diagnostics;
        return vb;
    }

    public static ArcVersionBlock parseVersionBlock(ArcReader reader, Diagnostics<Diagnosis> diagnostics, ArcHeader header, ArcFieldParsers fieldParsers, ByteCountingPushBackInputStream in) throws IOException {
        ArcVersionBlock vb = new ArcVersionBlock();
        vb.recordType = 1;
        vb.reader = reader;
        vb.diagnostics = diagnostics;
        vb.header = header;
        vb.in = in;
        vb.processPayload(in, reader);
        vb.consumed = in.getConsumed() - vb.header.startOffset;
        return vb;
    }

    protected void validateContentType() {
        if (this.header.contentType == null) {
            this.diagnostics.addError(new Diagnosis(DiagnosisType.ERROR_EXPECTED, "'Content-type' value", "<type>/<sub-type>(; <argument>=<value>)*"));
        } else if (!"text".equals(this.header.contentType.contentType) || !"plain".equals(this.header.contentType.mediaType)) {
            this.diagnostics.addWarning(new Diagnosis(DiagnosisType.INVALID_EXPECTED, "'Content-type' value", this.header.contentTypeStr, "text/plain"));
        }
    }

    @Override
    protected void processPayload(ByteCountingPushBackInputStream in, ArcReader reader) throws IOException {
        this.payload = null;
        this.validateContentType();
        if (this.header.archiveLength != null && this.header.archiveLength > 0L) {
            String digestAlgorithm = null;
            if (reader.bBlockDigest) {
                digestAlgorithm = reader.blockDigestAlgorithm;
            }
            this.payload = Payload.processPayload(in, this.header.archiveLength, reader.payloadHeaderMaxSize, digestAlgorithm);
            this.payload.setOnClosedHandler(this);
            digestAlgorithm = null;
            if (reader.bPayloadDigest) {
                digestAlgorithm = reader.payloadDigestAlgorithm;
            }
            this.versionHeader = ArcVersionHeader.processPayload(this.payload.getInputStream(), this.header.archiveLength, digestAlgorithm, reader.fieldParsers, this.diagnostics);
            if (this.versionHeader != null) {
                this.version = this.versionHeader.version;
                if (this.versionHeader.isValid()) {
                    this.payload.setPayloadHeaderWrapped(this.versionHeader);
                } else {
                    this.diagnostics.addError(new Diagnosis(DiagnosisType.ERROR, "ARC version block", "Version block is not valid!"));
                }
            }
        } else {
            this.diagnostics.addError(new Diagnosis(DiagnosisType.INVALID, "ARC file", "VersionBlock length missing!"));
        }
        if (this.versionHeader != null && this.versionHeader.isValid()) {
            if (ArcVersion.VERSION_1_1.equals((Object)this.version)) {
                if (this.versionHeader.getRemaining() == 0L) {
                    this.bHasPseudoEmptyPayload = true;
                    this.diagnostics.addError(new Diagnosis(DiagnosisType.ERROR_EXPECTED, "ARC file", "Expected metadata payload not found in the version block"));
                }
            } else if (this.versionHeader.getRemaining() == 0L) {
                this.bHasPseudoEmptyPayload = true;
            } else if (!reader.bStrict) {
                int read;
                if (this.versionHeader.getRemaining() > 0x100000L) {
                    throw new IOException("This amount of useless data in the version block is unacceptable!");
                }
                ByteArrayOutputStream out_payload = new ByteArrayOutputStream((int)this.versionHeader.getRemaining());
                ByteCountingPushBackInputStream in_payload = this.versionHeader.getPayloadInputStream();
                byte[] tmpBuf = new byte[1024];
                while ((read = ((InputStream)in_payload).read(tmpBuf)) != -1) {
                    out_payload.write(tmpBuf, 0, read);
                }
                ((InputStream)in_payload).close();
                out_payload.close();
                this.excessiveMetadata = out_payload.toByteArray();
                ByteArrayInputStream in_newlines = new ByteArrayInputStream(this.excessiveMetadata);
                if (!this.isValidStreamOfCRLF(in_newlines)) {
                    this.diagnostics.addError(new Diagnosis(DiagnosisType.UNDESIRED_DATA, "version block metadata payload", "Metadata payload must not be present in this version"));
                } else {
                    this.bHasPseudoEmptyPayload = true;
                }
                in_newlines.close();
            } else {
                this.diagnostics.addError(new Diagnosis(DiagnosisType.UNDESIRED_DATA, "version block metadata payload", "Metadata payload must not be present in this version"));
            }
        }
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(256);
        builder.append("\nVersionBlock : [\n");
        builder.append(super.toString());
        builder.append("]\n");
        if (this.versionHeader != null) {
            builder.append(this.versionHeader.toString());
        }
        return builder.toString();
    }
}

