/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.office;

import java.util.List;
import java.util.Locale;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class OfficeDescriptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(OfficeDescriptor.class);
    private String product = "???";
    private String version = "???";
    private boolean useLongOptionNameGnuStyle;

    private OfficeDescriptor() {
    }

    public static @NonNull OfficeDescriptor fromHelpOutput(@NonNull List<@NonNull String> lines) {
        OfficeDescriptor desc = new OfficeDescriptor();
        LOGGER.debug("Building {} from help output lines", (Object)OfficeDescriptor.class.getName());
        String productLine = null;
        for (String line : lines) {
            if (line.contains("--help")) {
                desc.useLongOptionNameGnuStyle = true;
                continue;
            }
            String lowerLine = line.trim().toLowerCase(Locale.ROOT);
            if (!lowerLine.startsWith("openoffice") && !lowerLine.startsWith("libreoffice")) continue;
            productLine = line.trim();
        }
        if (productLine != null) {
            String[] parts = productLine.split(" ");
            if (parts.length > 0) {
                desc.product = parts[0];
            }
            if (parts.length > 1) {
                desc.version = parts[1];
            }
        }
        LOGGER.info("soffice info (from help output): {}", (Object)desc.toString());
        return desc;
    }

    public static @NonNull OfficeDescriptor fromExecutablePath(@NonNull String path) {
        OfficeDescriptor desc = new OfficeDescriptor();
        String lowerPath = path.toLowerCase(Locale.ROOT);
        if (lowerPath.contains("libreoffice")) {
            desc.product = "LibreOffice";
            desc.useLongOptionNameGnuStyle = true;
        } else if (lowerPath.contains("openoffice")) {
            desc.product = "OpenOffice";
            desc.useLongOptionNameGnuStyle = false;
        }
        LOGGER.info("soffice info (from exec path): {}", (Object)desc.toString());
        return desc;
    }

    public @NonNull String getProduct() {
        return this.product;
    }

    public @NonNull String getVersion() {
        return this.version;
    }

    public boolean useLongOptionNameGnuStyle() {
        return this.useLongOptionNameGnuStyle;
    }

    public @NonNull String toString() {
        return String.format("Product: %s - Version: %s - useLongOptionNameGnuStyle: %s", this.getProduct(), this.getVersion(), this.useLongOptionNameGnuStyle());
    }
}

