/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.matcher.bytes;

import java.io.IOException;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.matcher.bytes.AbstractByteMatcher;
import net.byteseek.utils.ByteUtils;

public final class InvertedByteMatcher
extends AbstractByteMatcher {
    private final byte byteToMiss;

    public InvertedByteMatcher(byte byteToMiss) {
        this.byteToMiss = byteToMiss;
    }

    public InvertedByteMatcher(String hexByte) {
        this.byteToMiss = ByteUtils.byteFromHex(hexByte);
    }

    @Override
    public boolean matches(WindowReader reader, long matchPosition) throws IOException {
        Window window = reader.getWindow(matchPosition);
        return window == null ? false : window.getByte(reader.getWindowOffset(matchPosition)) != this.byteToMiss;
    }

    @Override
    public boolean matches(byte[] bytes, int matchPosition) {
        return matchPosition >= 0 && matchPosition < bytes.length && bytes[matchPosition] != this.byteToMiss;
    }

    @Override
    public boolean matchesNoBoundsCheck(byte[] bytes, int matchPosition) {
        return bytes[matchPosition] != this.byteToMiss;
    }

    @Override
    public boolean matches(byte theByte) {
        return theByte != this.byteToMiss;
    }

    @Override
    public byte[] getMatchingBytes() {
        byte[] matchingBytes = new byte[255];
        int byteIndex = 0;
        for (int byteValue = 0; byteValue < 256; ++byteValue) {
            byte theByte = (byte)byteValue;
            if (theByte == this.byteToMiss) continue;
            matchingBytes[byteIndex++] = theByte;
        }
        return matchingBytes;
    }

    @Override
    public String toRegularExpression(boolean prettyPrint) {
        return '^' + ByteUtils.byteToString(false, this.byteToMiss & 0xFF);
    }

    @Override
    public int getNumberOfMatchingBytes() {
        return 255;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[byte:" + String.format("%02x", this.byteToMiss & 0xFF) + ']';
    }
}

