/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.matcher.multisequence;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.matcher.multisequence.MultiSequenceMatcher;
import net.byteseek.matcher.multisequence.MultiSequenceUtils;
import net.byteseek.matcher.sequence.ByteSequenceMatcher;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.utils.ArgUtils;

public final class ListMultiSequenceMatcher
implements MultiSequenceMatcher {
    private final List<SequenceMatcher> matchers;
    private final int minimumLength;
    private final int maximumLength;

    public ListMultiSequenceMatcher(List<byte[]> bytesToMatch) {
        ArgUtils.checkNullObject(bytesToMatch, "bytesToMatch");
        this.matchers = new ArrayList<SequenceMatcher>(bytesToMatch.size());
        for (byte[] bytes : bytesToMatch) {
            ArgUtils.checkNullObject(bytes, "A byte array in the list of arrays.");
            ByteSequenceMatcher sequence = new ByteSequenceMatcher(bytes);
            this.matchers.add(sequence);
        }
        if (this.matchers.isEmpty()) {
            this.minimumLength = 0;
            this.maximumLength = 0;
        } else {
            int minLength = Integer.MAX_VALUE;
            int maxLength = Integer.MIN_VALUE;
            for (SequenceMatcher matcher : this.matchers) {
                int length = matcher.length();
                minLength = Math.min(minLength, length);
                maxLength = Math.max(maxLength, length);
            }
            this.minimumLength = minLength;
            this.maximumLength = maxLength;
        }
    }

    public ListMultiSequenceMatcher(Collection<? extends SequenceMatcher> matchersToUse) {
        ArgUtils.checkNullObject(matchersToUse, "matchersToUser");
        this.matchers = new ArrayList<SequenceMatcher>(matchersToUse);
        for (SequenceMatcher matcher : this.matchers) {
            ArgUtils.checkNullObject(matcher, "a matcher in the matchersToUse collection");
        }
        if (this.matchers.isEmpty()) {
            this.minimumLength = 0;
            this.maximumLength = 0;
        } else {
            int minLength = Integer.MAX_VALUE;
            int maxLength = Integer.MIN_VALUE;
            for (SequenceMatcher matcher : this.matchers) {
                int length = matcher.length();
                minLength = Math.min(minLength, length);
                maxLength = Math.max(maxLength, length);
            }
            this.minimumLength = minLength;
            this.maximumLength = maxLength;
        }
    }

    public List<SequenceMatcher> allMatches(WindowReader reader, long matchPosition) throws IOException {
        List<SequenceMatcher> result = Collections.emptyList();
        List<SequenceMatcher> localMatchers = this.matchers;
        for (SequenceMatcher sequence : localMatchers) {
            if (!sequence.matches(reader, matchPosition)) continue;
            if (result.isEmpty()) {
                result = new ArrayList<SequenceMatcher>(2);
            }
            result.add(sequence);
        }
        return result;
    }

    @Override
    public Collection<SequenceMatcher> allMatches(byte[] bytes, int matchPosition) {
        List<SequenceMatcher> result;
        block6: {
            result = Collections.emptyList();
            long noOfBytes = bytes.length;
            if (matchPosition < this.minimumLength - 1 || (long)(matchPosition + this.minimumLength) >= noOfBytes) break block6;
            List<SequenceMatcher> localMatchers = this.matchers;
            if ((long)(matchPosition + this.maximumLength) < noOfBytes) {
                for (SequenceMatcher sequence : localMatchers) {
                    if (!sequence.matchesNoBoundsCheck(bytes, matchPosition)) continue;
                    if (result.isEmpty()) {
                        result = new ArrayList<SequenceMatcher>(2);
                    }
                    result.add(sequence);
                }
            } else {
                for (SequenceMatcher sequence : localMatchers) {
                    if (!sequence.matches(bytes, matchPosition)) continue;
                    if (result.isEmpty()) {
                        result = new ArrayList<SequenceMatcher>(2);
                    }
                    result.add(sequence);
                }
            }
        }
        return result;
    }

    @Override
    public Collection<SequenceMatcher> allMatchesBackwards(WindowReader reader, long matchPosition) throws IOException {
        List<SequenceMatcher> result = Collections.emptyList();
        List<SequenceMatcher> localMatchers = this.matchers;
        long onePastMatchPosition = matchPosition + 1L;
        for (SequenceMatcher sequence : localMatchers) {
            if (!sequence.matches(reader, onePastMatchPosition - (long)sequence.length())) continue;
            if (result.isEmpty()) {
                result = new ArrayList<SequenceMatcher>(2);
            }
            result.add(sequence);
        }
        return result;
    }

    @Override
    public Collection<SequenceMatcher> allMatchesBackwards(byte[] bytes, int matchPosition) {
        List<SequenceMatcher> result;
        block6: {
            result = Collections.emptyList();
            int noOfBytes = bytes.length;
            if (matchPosition < this.minimumLength - 1 || matchPosition >= noOfBytes) break block6;
            List<SequenceMatcher> localMatchers = this.matchers;
            int onePastMatchPosition = matchPosition + 1;
            if (onePastMatchPosition >= this.maximumLength) {
                for (SequenceMatcher sequence : localMatchers) {
                    if (!sequence.matchesNoBoundsCheck(bytes, onePastMatchPosition - sequence.length())) continue;
                    if (result.isEmpty()) {
                        result = new ArrayList<SequenceMatcher>(2);
                    }
                    result.add(sequence);
                }
            } else {
                for (SequenceMatcher sequence : localMatchers) {
                    if (!sequence.matches(bytes, onePastMatchPosition - sequence.length())) continue;
                    if (result.isEmpty()) {
                        result = new ArrayList<SequenceMatcher>(2);
                    }
                    result.add(sequence);
                }
            }
        }
        return result;
    }

    @Override
    public SequenceMatcher firstMatch(WindowReader reader, long matchPosition) throws IOException {
        List<SequenceMatcher> localMatchers = this.matchers;
        for (SequenceMatcher sequence : localMatchers) {
            if (!sequence.matches(reader, matchPosition)) continue;
            return sequence;
        }
        return null;
    }

    @Override
    public SequenceMatcher firstMatch(byte[] bytes, int matchPosition) {
        block4: {
            long noOfBytes = bytes.length;
            if (matchPosition < this.minimumLength - 1 || (long)(matchPosition + this.minimumLength) >= noOfBytes) break block4;
            List<SequenceMatcher> localMatchers = this.matchers;
            if ((long)(matchPosition + this.maximumLength) < noOfBytes) {
                for (SequenceMatcher sequence : localMatchers) {
                    if (!sequence.matchesNoBoundsCheck(bytes, matchPosition)) continue;
                    return sequence;
                }
            } else {
                for (SequenceMatcher sequence : localMatchers) {
                    if (!sequence.matches(bytes, matchPosition)) continue;
                    return sequence;
                }
            }
        }
        return null;
    }

    @Override
    public SequenceMatcher firstMatchBackwards(WindowReader reader, long matchPosition) throws IOException {
        List<SequenceMatcher> localMatchers = this.matchers;
        long onePastMatchPosition = matchPosition + 1L;
        for (SequenceMatcher sequence : localMatchers) {
            if (!sequence.matches(reader, onePastMatchPosition - (long)sequence.length())) continue;
            return sequence;
        }
        return null;
    }

    @Override
    public SequenceMatcher firstMatchBackwards(byte[] bytes, int matchPosition) {
        block4: {
            int noOfBytes = bytes.length;
            if (matchPosition < this.minimumLength - 1 || matchPosition >= noOfBytes) break block4;
            List<SequenceMatcher> localMatchers = this.matchers;
            int onePastMatchPosition = matchPosition + 1;
            if (onePastMatchPosition >= this.maximumLength) {
                for (SequenceMatcher sequence : localMatchers) {
                    if (!sequence.matchesNoBoundsCheck(bytes, onePastMatchPosition - sequence.length())) continue;
                    return sequence;
                }
            } else {
                for (SequenceMatcher sequence : localMatchers) {
                    if (!sequence.matches(bytes, onePastMatchPosition - sequence.length())) continue;
                    return sequence;
                }
            }
        }
        return null;
    }

    @Override
    public boolean matches(WindowReader reader, long matchPosition) throws IOException {
        List<SequenceMatcher> localMatchers = this.matchers;
        for (SequenceMatcher sequence : localMatchers) {
            if (!sequence.matches(reader, matchPosition)) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matches(byte[] bytes, int matchPosition) {
        block4: {
            int noOfBytes = bytes.length;
            if (matchPosition < this.minimumLength - 1 || matchPosition + this.minimumLength >= noOfBytes) break block4;
            List<SequenceMatcher> localMatchers = this.matchers;
            if (matchPosition + this.maximumLength < noOfBytes) {
                for (SequenceMatcher sequence : localMatchers) {
                    if (!sequence.matchesNoBoundsCheck(bytes, matchPosition)) continue;
                    return true;
                }
            } else {
                for (SequenceMatcher sequence : localMatchers) {
                    if (!sequence.matches(bytes, matchPosition)) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public boolean matchesBackwards(WindowReader reader, long matchPosition) throws IOException {
        List<SequenceMatcher> localMatchers = this.matchers;
        long onePastMatchPosition = matchPosition + 1L;
        for (SequenceMatcher sequence : localMatchers) {
            if (!sequence.matches(reader, onePastMatchPosition - (long)sequence.length())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean matchesBackwards(byte[] bytes, int matchPosition) {
        block4: {
            int noOfBytes = bytes.length;
            if (matchPosition < this.minimumLength - 1 || matchPosition >= noOfBytes) break block4;
            List<SequenceMatcher> localMatchers = this.matchers;
            int onePastMatchPosition = matchPosition + 1;
            if (onePastMatchPosition >= this.maximumLength) {
                for (SequenceMatcher sequence : localMatchers) {
                    if (!sequence.matchesNoBoundsCheck(bytes, onePastMatchPosition - sequence.length())) continue;
                    return true;
                }
            } else {
                for (SequenceMatcher sequence : localMatchers) {
                    if (!sequence.matches(bytes, onePastMatchPosition - sequence.length())) continue;
                    return true;
                }
            }
        }
        return false;
    }

    @Override
    public int getMinimumLength() {
        return this.minimumLength;
    }

    @Override
    public int getMaximumLength() {
        return this.maximumLength;
    }

    @Override
    public MultiSequenceMatcher reverse() {
        return new ListMultiSequenceMatcher((Collection<? extends SequenceMatcher>)MultiSequenceUtils.reverseMatchers(this.matchers));
    }

    @Override
    public MultiSequenceMatcher newInstance(Collection<? extends SequenceMatcher> sequences) {
        return new ListMultiSequenceMatcher(sequences);
    }

    @Override
    public List<SequenceMatcher> getSequenceMatchers() {
        return new ArrayList<SequenceMatcher>(this.matchers);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[matchers:" + this.matchers + ']';
    }
}

