/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.matchUtils;

import com.exlibris.core.infra.common.matchUtils.DigitsMatcher;
import com.exlibris.core.infra.common.matchUtils.Phrase;
import org.apache.commons.lang.StringUtils;
import uk.ac.shef.wit.simmetrics.similaritymetrics.Levenshtein;

public class MatchingUtil {
    private static final double LEVENSHTEIN_MIN_MATCHING_DISTANCE = 0.75;
    private static final double LEVENSHTEIN_SEQUENTIAL_MATCHING_DISTANCE = 0.9;
    private static DigitsMatcher digitsMatcher;
    private static Levenshtein levenshtein;

    private static Levenshtein getLevenshtein() {
        if (levenshtein == null) {
            levenshtein = new Levenshtein();
        }
        return levenshtein;
    }

    private static DigitsMatcher getdigitsMatcher() {
        if (digitsMatcher == null) {
            digitsMatcher = new DigitsMatcher();
        }
        return digitsMatcher;
    }

    public static int getPhraseMatch(String phraseStr1, String phraseStr2) {
        if (StringUtils.isEmpty((String)phraseStr1) || StringUtils.isEmpty((String)phraseStr2)) {
            return 0;
        }
        if (phraseStr1.equalsIgnoreCase(phraseStr2)) {
            return 100;
        }
        Phrase phrase1 = new Phrase(phraseStr1.toLowerCase());
        Phrase phrase2 = new Phrase(phraseStr2.toLowerCase());
        if (phrase1.length() == 1 && phrase2.length() == 1) {
            return MatchingUtil.getWordMatchPercentage(phrase1.get(0), phrase2.get(0));
        }
        return (int)MatchingUtil.getPhraseMatchConsiderSequentialTokens(phrase1, phrase2, false);
    }

    public static int getPhraseMatchCheckForContains(String phraseStr1, String phraseStr2) {
        if (StringUtils.isEmpty((String)phraseStr1) || StringUtils.isEmpty((String)phraseStr2)) {
            return 0;
        }
        if (phraseStr1.equalsIgnoreCase(phraseStr2)) {
            return 100;
        }
        Phrase phrase1 = new Phrase(phraseStr1.toLowerCase());
        Phrase phrase2 = new Phrase(phraseStr2.toLowerCase());
        if (phrase1.length() == 1 && phrase2.length() == 1) {
            return MatchingUtil.getWordMatchPercentage(phrase1.get(0), phrase2.get(0));
        }
        return (int)MatchingUtil.getPhraseMatchConsiderSequentialTokens(phrase1, phrase2, true);
    }

    public static int getAbbreviationMatch(String phraseStr1, String phraseStr2) {
        if (StringUtils.isEmpty((String)phraseStr1) || StringUtils.isEmpty((String)phraseStr2)) {
            return 0;
        }
        if (phraseStr1.equalsIgnoreCase(phraseStr2)) {
            return 100;
        }
        Phrase phrase1 = new Phrase(phraseStr1.toLowerCase());
        Phrase phrase2 = new Phrase(phraseStr2.toLowerCase());
        return (int)MatchingUtil.matchAbbreviation(phrase1, phrase2);
    }

    public static int getStartWithMatch(String phrase1, String phrase2) {
        String str2;
        if (StringUtils.isEmpty((String)phrase1) || StringUtils.isEmpty((String)phrase2)) {
            return 0;
        }
        if (phrase1.length() < 3 && phrase2.length() < 3 || phrase1.length() == phrase2.length()) {
            return 0;
        }
        int minLength = Math.min(phrase1.length(), phrase2.length());
        String str1 = phrase1.substring(0, minLength).replaceAll(" ", "").toLowerCase();
        if (str1.equals(str2 = phrase2.substring(0, minLength).replaceAll(" ", "").toLowerCase())) {
            return 100;
        }
        return (int)MatchingUtil.levenshteinWordMatch(str1, str2);
    }

    public static int getEndsWithMatch(String phrase1, String phrase2) {
        if (StringUtils.isEmpty((String)phrase1) || StringUtils.isEmpty((String)phrase2)) {
            return 0;
        }
        if (phrase1.length() < 3 && phrase2.length() < 3 || phrase1.length() == phrase2.length()) {
            return 0;
        }
        String str1 = null;
        String str2 = null;
        if (phrase1.length() < phrase2.length()) {
            str1 = phrase1.toLowerCase();
            str2 = phrase2.substring(phrase2.length() - phrase1.length(), phrase2.length()).toLowerCase();
        } else if (phrase1.length() > phrase2.length()) {
            str2 = phrase2.toLowerCase();
            str1 = phrase1.substring(phrase1.length() - phrase2.length(), phrase1.length()).toLowerCase();
        }
        return (int)MatchingUtil.levenshteinWordMatch(str1.replaceAll(" ", ""), str2.replaceAll(" ", ""));
    }

    public static double levenshteinWordMatch(String string1, String string2) {
        return MatchingUtil.getLevenshtein().getSimilarity(string1, string2);
    }

    public static int getWordMatchPercentage(String string1, String string2) {
        int match = (int)(MatchingUtil.getLevenshtein().getSimilarity(string1, string2) * 100.0f);
        if (match >= 50) {
            return match;
        }
        return 0;
    }

    public static boolean isWordMatch(String string1, String string2) {
        if (string1 == null || string2 == null) {
            return false;
        }
        if (string1.equalsIgnoreCase(string2)) {
            return true;
        }
        return MatchingUtil.is2AdjacentMatch(string1, string2) || MatchingUtil.levenshteinWordMatch(string1, string2) >= 0.75;
    }

    public static int isDigitMatch(String digitStr1, String digitStr2) {
        if (StringUtils.isEmpty((String)digitStr1) || StringUtils.isEmpty((String)digitStr2)) {
            return 0;
        }
        return MatchingUtil.getdigitsMatcher().match(digitStr1, digitStr2);
    }

    private static double getPhraseMatchConsiderSequentialTokens(Phrase phrase1, Phrase phrase2, boolean checkContains) {
        double totalNumberOfTokens = phrase1.length() + phrase2.length();
        double numberOfMatchedTokens = 0.0;
        for (int i = 0; i < phrase1.length(); ++i) {
            for (int j = 0; j < phrase2.length(); ++j) {
                int numOfWordsMathced = 0;
                if (phrase1.foundAt(i).booleanValue() || phrase2.foundAt(j).booleanValue()) continue;
                if (phrase1.lengthAt(i) == phrase2.lengthAt(j)) {
                    if (MatchingUtil.isWordMatch(phrase1.get(i), phrase2.get(j))) {
                        phrase1.setAsFoundAt(i);
                        phrase2.setAsFoundAt(j);
                    }
                } else if (phrase1.lengthAt(i) > phrase2.lengthAt(j)) {
                    numOfWordsMathced = MatchingUtil.getNumOfSequentialTokens(phrase1, phrase2, i, j);
                    j += numOfWordsMathced;
                } else if (phrase1.lengthAt(i) < phrase2.lengthAt(j)) {
                    numOfWordsMathced = MatchingUtil.getNumOfSequentialTokens(phrase2, phrase1, j, i);
                    i += numOfWordsMathced;
                }
                if (!phrase1.foundAt(i).booleanValue() && phrase1.lengthAt(i) != phrase2.lengthAt(j) && MatchingUtil.isWordMatch(phrase1.get(i), phrase2.get(j))) {
                    phrase1.setAsFoundAt(i);
                    phrase2.setAsFoundAt(j);
                }
                if (checkContains && !phrase1.foundAt(i).booleanValue() && MatchingUtil.containsMatch(phrase1.get(i), phrase2.get(j))) {
                    phrase1.setAsFoundAt(i);
                    phrase2.setAsFoundAt(j);
                }
                if (!phrase1.foundAt(i).booleanValue()) continue;
                totalNumberOfTokens -= (double)numOfWordsMathced;
                numberOfMatchedTokens += 2.0;
            }
        }
        return numberOfMatchedTokens / totalNumberOfTokens * 100.0;
    }

    private static int getNumOfSequentialTokens(Phrase phrase1, Phrase phrase2, int i, int j) {
        String combinedWords = "";
        int startIndex = j;
        for (int k = j; combinedWords.length() < phrase1.lengthAt(i) && k < phrase2.length(); ++k) {
            combinedWords = combinedWords + phrase2.get(k);
            if (!(MatchingUtil.levenshteinWordMatch(phrase1.get(i), combinedWords) > 0.9)) continue;
            phrase1.setAsFoundAt(i);
            phrase2.markAsMatched(j, k);
            j = k;
        }
        return j - startIndex;
    }

    private static double matchAbbreviation(Phrase phrase1, Phrase phrase2) {
        String abb1 = "";
        String abb2 = "";
        if (phrase1.length() < 2 && phrase2.length() < 2) {
            return 0.0;
        }
        for (int i = phrase1.length() - 1; i >= 0; --i) {
            for (int j = phrase2.length() - 1; j >= 0; --j) {
                if (phrase1.foundAt(i).booleanValue() || phrase2.foundAt(j).booleanValue() || !MatchingUtil.isWordMatch(phrase1.get(i), phrase2.get(j))) continue;
                phrase1.setAsFoundAt(i);
                phrase2.setAsFoundAt(j);
            }
        }
        String[] abbArr1 = phrase1.getUnMatchedPhrase();
        String[] abbArr2 = phrase2.getUnMatchedPhrase();
        if (abbArr1 == null || abbArr2 == null) {
            return 0.0;
        }
        String matchedWords1 = phrase1.getMatchedString();
        String matchedWords2 = phrase2.getMatchedString();
        if (abbArr1.length == 1 && abbArr2.length > 1) {
            abb2 = MatchingUtil.getFirstCharForEachWord(abbArr2, -1);
            abb1 = abbArr1[0];
        } else if (abbArr2.length == 1 && abbArr1.length > 1) {
            abb1 = MatchingUtil.getFirstCharForEachWord(abbArr1, -1);
            abb2 = abbArr2[0];
        } else if (abbArr1[0].length() == 3 && abbArr2.length > 2) {
            abb2 = MatchingUtil.getFirstCharForEachWord(abbArr2, 3);
            abb1 = MatchingUtil.getConcantinatedString(abbArr1, 1);
        } else if (abbArr2[0].length() == 3 && abbArr1.length > 2) {
            abb1 = MatchingUtil.getFirstCharForEachWord(abbArr1, 3);
            abb2 = MatchingUtil.getConcantinatedString(abbArr2, 1);
        } else if (abbArr1[0].length() == 4 && abbArr2.length > 3) {
            abb2 = MatchingUtil.getFirstCharForEachWord(abbArr2, 4);
            abb1 = MatchingUtil.getConcantinatedString(abbArr1, 1);
        } else if (abbArr2[0].length() == 4 && abbArr1.length > 3) {
            abb1 = MatchingUtil.getFirstCharForEachWord(abbArr1, 4);
            abb2 = MatchingUtil.getConcantinatedString(abbArr2, 1);
        } else {
            int i;
            for (i = 0; i < Math.min(abbArr1.length, abbArr2.length) && !MatchingUtil.getConcantinatedReplacedString(abbArr1, i).equals(MatchingUtil.getConcantinatedReplacedString(abbArr2, i)); ++i) {
                if (abbArr1[i].length() > abbArr2[i].length() && abbArr1[i].charAt(0) == abbArr2[i].charAt(0) && !StringUtils.isNumeric((String)abbArr1[i].substring(0, 1)) && !StringUtils.isNumeric((String)abbArr2[i].substring(0, 1))) {
                    abb1 = abb1 + abbArr1[i].substring(0, 1) + " ";
                    abb2 = abb2 + abbArr2[i] + " ";
                    continue;
                }
                if (abbArr1[i].length() < abbArr2[i].length() && abbArr1[i].charAt(0) == abbArr2[i].charAt(0) && !StringUtils.isNumeric((String)abbArr1[i].substring(0, 1)) && !StringUtils.isNumeric((String)abbArr2[i].substring(0, 1))) {
                    abb1 = abb1 + abbArr1[i] + " ";
                    abb2 = abb2 + abbArr2[i].substring(0, 1) + " ";
                    continue;
                }
                abb1 = abb1 + abbArr1[i] + " ";
                abb2 = abb2 + abbArr2[i] + " ";
            }
            abb2 = abb2 + MatchingUtil.getRemainingString(i, abbArr1, abbArr2);
            abb1 = abb1 + MatchingUtil.getRemainingString(i, abbArr2, abbArr1);
        }
        return MatchingUtil.getPhraseMatch(matchedWords1 + abb1, matchedWords2 + abb2);
    }

    private static String getRemainingString(int index, String[] abbArr1, String[] abbArr2) {
        String ret = "";
        if (abbArr1.length < abbArr2.length || index < abbArr2.length) {
            while (index < abbArr2.length) {
                ret = ret + abbArr2[index] + " ";
                ++index;
            }
        }
        return ret;
    }

    private static String getFirstCharForEachWord(String[] phrase, int numToGet) {
        String ret = "";
        if (numToGet == -1) {
            numToGet = phrase.length;
        }
        for (int i = 0; i < phrase.length && i < numToGet; ++i) {
            ret = ret + phrase[i].substring(0, 1) + " ";
        }
        return ret;
    }

    private static String getConcantinatedString(String[] phrase, int numToGet) {
        StringBuilder b = new StringBuilder();
        if (numToGet == -1) {
            numToGet = phrase.length;
        }
        for (int i = 0; i < phrase.length && i < numToGet; ++i) {
            b.append(phrase[i]).append(" ");
        }
        return b.toString();
    }

    private static String getConcantinatedReplacedString(String[] phrase, int fromIndex) {
        StringBuilder b = new StringBuilder();
        for (int i = fromIndex; i < phrase.length; ++i) {
            b.append(phrase[i]);
        }
        return b.toString();
    }

    private static boolean is2AdjacentMatch(String str1, String str2) {
        boolean foundAdjacent = false;
        if (str1.length() != str2.length() || str2.length() < 3) {
            return false;
        }
        for (int i = 0; i < str1.length(); ++i) {
            if (str1.charAt(i) == str2.charAt(i) || str1.charAt(i) == str2.charAt(i)) continue;
            if (!foundAdjacent && i < str1.length() - 1 && str1.charAt(i + 1) == str2.charAt(i) && str1.charAt(i) == str2.charAt(i + 1)) {
                foundAdjacent = true;
                ++i;
                continue;
            }
            return false;
        }
        return true;
    }

    private static boolean containsMatch(String str1, String str2) {
        if (str1.length() > 3 && str2.length() > 3 && (str1.contains(str2) || str2.contains(str1))) {
            return true;
        }
        return (str1.length() > 2 && str2.length() > 4 || str2.length() > 2 && str1.length() > 4) && (str1.startsWith(str2) || str2.startsWith(str1));
    }
}

