/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.common.streams;

import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.sdk.utils.FileUtil;
import com.exlibris.digitool.common.streams.FailedToHandlerStreamException;
import com.exlibris.digitool.common.streams.StreamHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.UnsupportedCharsetException;
import java.util.Arrays;

public class TextExtractorStreamHandler
extends StreamHandler {
    private static final ExLogger logger = ExLogger.getExLogger(TextExtractorStreamHandler.class);
    private static final String START_TAGS = "<html><body><pre>";
    private static final String END_TAGS = "</pre></body></html>";
    private static final String[] formattedFiles = new String[]{"html", "htm"};
    private String encoding = "UTF-8";
    private static final String UTF8 = "UTF-8";

    @Override
    public void handleStream() throws FailedToHandlerStreamException {
        String fileToRead = null;
        String fileToWrite = null;
        if (this.params == null || this.params.length != 2) {
            throw new FailedToHandlerStreamException("one of the following is missing: 'file to read', 'file to write'");
        }
        fileToRead = this.params[0];
        fileToWrite = this.params[1];
        this.formatStream(fileToRead, fileToWrite);
    }

    public void formatStream(String fileToRead, String fileToWrite) throws FailedToHandlerStreamException {
        if (fileToRead != null) {
            boolean format = this.shouldBeFormatted(FileUtil.getExtension(fileToRead));
            FileInputStream input = null;
            OutputStream os = null;
            StringBuffer document = new StringBuffer();
            try {
                long fln;
                int len = 0;
                input = new FileInputStream(fileToRead);
                byte[] buf = new byte[input.available()];
                if (format) {
                    document.append(START_TAGS);
                }
                if ((fln = new File(fileToRead).length()) > 0L) {
                    while ((len = input.read(buf)) != -1) {
                        String str;
                        try {
                            str = new String(buf, 0, len, this.encoding);
                        }
                        catch (UnsupportedCharsetException e) {
                            str = new String(buf);
                        }
                        catch (IndexOutOfBoundsException e) {
                            str = new String(buf);
                        }
                        document.append(str.toLowerCase());
                    }
                }
                if (format) {
                    document.append(END_TAGS);
                }
                if (document.length() > 0) {
                    os = new FileOutputStream(fileToWrite);
                    os.write(document.toString().getBytes(UTF8));
                }
            }
            catch (FileNotFoundException e) {
                if (input == null) {
                    logger.info(DescriptorConstants.GN_FailedToReadFile, (Object)fileToRead, (Object)e.getMessage());
                    throw new FailedToHandlerStreamException("failed to create index file, '" + fileToRead + "' - not found: " + e.getStackTrace());
                }
                logger.info(DescriptorConstants.GN_FailedToReadFile, (Object)fileToWrite, (Object)e.getMessage());
                throw new FailedToHandlerStreamException("failed to create index file, '" + fileToWrite + "' - not found: " + e.getStackTrace());
            }
            catch (SecurityException e) {
                if (input == null) {
                    logger.info(DescriptorConstants.GN_FailedToReadFile, (Object)fileToRead, (Object)e.getMessage());
                    throw new FailedToHandlerStreamException("failed to create index file, '" + fileToRead + "' - cannot be read: " + e.getStackTrace());
                }
                logger.info(DescriptorConstants.GN_FailedToReadFile, (Object)fileToWrite, (Object)e.getMessage());
                throw new FailedToHandlerStreamException("failed to create index file, '" + fileToWrite + "' - cannot be write: " + e.getStackTrace());
            }
            catch (IOException e) {
                logger.info(DescriptorConstants.IN_UnableToSaveStreamFile, (Object)fileToWrite, (Object)e.getMessage());
                throw new FailedToHandlerStreamException("failed to create index file, '" + fileToWrite + "' - cannot be write: " + e.getStackTrace());
            }
            finally {
                try {
                    if (input != null) {
                        input.close();
                    }
                    if (os != null) {
                        os.close();
                    }
                }
                catch (IOException ex) {
                    logger.info(DescriptorConstants.GN_UnableToCloseStream, (Object)ex.getMessage());
                }
            }
        }
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    private boolean shouldBeFormatted(String fileExt) {
        return fileExt == null || fileExt.trim().length() == 0 || !Arrays.asList(formattedFiles).contains(fileExt);
    }
}

