/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.common;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;

public class ByteCountingInputStream
extends FilterInputStream {
    public static final int READLINE_INITIAL_SIZE = 128;
    protected long consumed = 0L;
    protected long counter = 0L;

    public ByteCountingInputStream(InputStream in) {
        super(in);
    }

    public long getConsumed() {
        return this.consumed;
    }

    public void setCounter(long bytes) {
        this.counter = bytes;
    }

    public long getCounter() {
        return this.counter;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read() throws IOException {
        int b = this.in.read();
        if (b != -1) {
            ++this.consumed;
            ++this.counter;
        }
        return b;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = this.in.read(b, off, len);
        if (bytesRead > 0) {
            this.consumed += (long)bytesRead;
            this.counter += (long)bytesRead;
        }
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        long bytesSkipped = this.in.skip(n);
        this.consumed += bytesSkipped;
        this.counter += bytesSkipped;
        return bytesSkipped;
    }
}

