/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.converter.dpf4;

import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.out.Logger;
import com.sealsystems.dpf4convert.v1_3_.DPFWSException_Exception;
import com.sealsystems.dpf4convert.v1_3_.Dpf4CService;
import com.sealsystems.dpf4convert.v1_3_.types.attach.ConvertIN;
import com.sealsystems.dpf4convert.v1_3_.types.attach.ConvertOfficeIN;
import com.sealsystems.dpf4convert.v1_3_.types.attach.ConvertResult;
import com.sealsystems.dpf4convert.v1_3_.types.attach.FileConfig;
import com.sealsystems.dpf4convert.v1_3_.types.attach.FileConfigNative;
import com.sealsystems.dpf4convert.v1_3_.types.attach.ObjectFactory;
import com.sun.xml.ws.encoding.DataSourceStreamingDataHandler;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.Arrays;
import java.util.Optional;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.activation.FileDataSource;
import javax.xml.bind.JAXBElement;
import joptsimple.OptionException;
import joptsimple.OptionParser;
import joptsimple.OptionSet;

public class ConvertOperation {
    protected String operationName;
    protected Dpf4CService service;
    protected String[] args;
    public static final String OPERATION_NAME = "convert";

    ConvertOperation(String operationName, Dpf4CService service, String[] args) {
        this.operationName = operationName;
        this.service = service;
        this.args = Arrays.copyOf(args, args.length);
    }

    ConvertOperation(Dpf4CService service, String[] args) {
        this(OPERATION_NAME, service, args);
    }

    public static Optional<ConvertOperation> createOperation(Dpf4CService service, String ... args) {
        Optional<ConvertOperation> result = Optional.empty();
        if (args.length == 0) {
            return result;
        }
        if (OPERATION_NAME.equals(args[0])) {
            result = Optional.of(new ConvertOperation(service, Arrays.copyOfRange(args, 1, args.length)));
        }
        return result;
    }

    public static String getSyntax() {
        return String.format("%s --%s=[path/to/]sourceFile --%s=[path/to/]destinationFile [--%s=profile]", OPERATION_NAME, Parameter.SourceFile.getName(), Parameter.DestinationFile.getName(), Parameter.Profile.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        String profile;
        String destinationFilePath;
        String sourceFilePath;
        OptionParser parser = new OptionParser();
        parser.accepts(Parameter.SourceFile.getName()).withRequiredArg().required();
        parser.accepts(Parameter.DestinationFile.getName()).withRequiredArg().required();
        parser.accepts(Parameter.Profile.getName()).withRequiredArg().defaultsTo((Object[])new String[]{""});
        try {
            OptionSet options = parser.parse(this.args);
            sourceFilePath = options.valueOf(Parameter.SourceFile.getName()).toString();
            destinationFilePath = options.valueOf(Parameter.DestinationFile.getName()).toString();
            profile = options.valueOf(Parameter.Profile.getName()).toString();
        }
        catch (NullPointerException | OptionException e) {
            Logger.error((Object)"Wrong arguments !", (Throwable)e);
            Logger.error((Object)String.format("Usage: %s", ConvertOperation.getSyntax()));
            return;
        }
        File sourceFile = new File(sourceFilePath);
        if (!sourceFile.exists()) {
            Logger.error((Object)(Parameter.SourceFile + " missing:" + destinationFilePath + "\nAbandoning ..."));
            return;
        }
        File destinationFile = new File(destinationFilePath);
        if (destinationFile.exists()) {
            Logger.error((Object)(Parameter.DestinationFile + " already existing:" + destinationFilePath + "\nAbandoning ..."));
            return;
        }
        FileDataSource dataSource = new FileDataSource(sourceFilePath);
        DataSourceStreamingDataHandler dataHandler = new DataSourceStreamingDataHandler((DataSource)dataSource);
        ObjectFactory attachObjectFactory = new ObjectFactory();
        com.sealsystems.dpf4convert.v1_3_.types.common.ObjectFactory commonObjectFactory = new com.sealsystems.dpf4convert.v1_3_.types.common.ObjectFactory();
        FileConfig fileConfig = attachObjectFactory.createFileConfig();
        fileConfig.setDataHandler((DataHandler)dataHandler);
        fileConfig.setFileName(sourceFile.getName());
        ConvertOfficeIN convertOfficeIN = attachObjectFactory.createConvertOfficeIN();
        convertOfficeIN.setFileConfig(fileConfig);
        FileConfigNative fileConfigNative = attachObjectFactory.createFileConfigNative();
        fileConfigNative.setDataHandler((DataHandler)dataHandler);
        fileConfigNative.setFileName(sourceFile.getName());
        ConvertIN convertIN = attachObjectFactory.createConvertIN();
        convertIN.setFileConfigNative(fileConfigNative);
        if (!profile.isEmpty()) {
            JAXBElement<String> profileJAXB = commonObjectFactory.createConvertINBaseProfile(profile);
            convertIN.setProfile(profileJAXB);
        }
        InputStream is = null;
        try {
            Logger.info((Object)String.format("Conversion started: Source: %s (size: %s)", sourceFilePath, FileUtil.getHumanReadableFileSize((File)sourceFile)));
            ConvertResult convertResult = this.service.convert(convertIN);
            DataHandler dh = convertResult.getDataHandler();
            is = dh.getInputStream();
            Files.copy(is, destinationFile.toPath(), new CopyOption[0]);
            Logger.info((Object)String.format("Conversion finished: Destination: %s (size: %s)", destinationFilePath, FileUtil.getHumanReadableFileSize((File)new File(destinationFilePath))));
        }
        catch (DPFWSException_Exception e) {
            Logger.error((Object)String.format("Conversion failure: Error code: %d, Message: %s", e.getFaultInfo().getErrCode(), e.getFaultInfo().getMessage()), (Throwable)e);
            try {
                FileUtil.delete((File)destinationFile);
            }
            catch (FileUtilExceptionListException ex) {
                Logger.error((Object)"FileUtilExceptionListException during conversion !", (Throwable)ex);
            }
        }
        catch (IOException e) {
            Logger.error((Object)"IOException during conversion !", (Throwable)e);
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException e) {
                    Logger.error((Object)"IOException when closing InputStream!", (Throwable)e);
                }
            }
        }
    }

    private static enum Parameter {
        SourceFile,
        DestinationFile,
        Profile;


        public String getName() {
            switch (this) {
                case SourceFile: {
                    return "sourceFile";
                }
                case DestinationFile: {
                    return "destinationFile";
                }
                case Profile: {
                    return "profile";
                }
            }
            return "";
        }
    }
}

