/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.ingest;

import ch.docuteam.darc.ingest.AIPCreator;
import ch.docuteam.darc.mdconfig.LevelOfDescription;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.tools.file.FileUtil;
import ch.docuteam.tools.file.Zipper;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.os.OperatingSystem;
import ch.docuteam.tools.out.Logger;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Properties;
import java.util.Vector;

public class AIPCreatorBasic
implements AIPCreator {
    private String ingestSubmitDir;

    @Override
    public void initialize(Properties properties) throws Exception {
        String osSuffix = OperatingSystem.isWindows() ? "Win" : (OperatingSystem.isMacOSX() ? "OSX" : (OperatingSystem.isLinux() ? "Linux" : ""));
        this.ingestSubmitDir = properties.getProperty("AIPCreator.ingestSubmitDir." + osSuffix);
        if (this.ingestSubmitDir == null) {
            throw new NullPointerException("Missing property: 'AIPCreator.ingestSubmitDir'");
        }
    }

    @Override
    public List<String> checkSubmission(Document document) {
        Vector<String> rejectMessages = new Vector<String>();
        if (document.isModified()) {
            Logger.debug((Object)"Can't submit because SIP has unsaved changes");
            rejectMessages.add("MessageSubmitUnsavedChanges");
        }
        if (!Files.exists(Paths.get(this.ingestSubmitDir, new String[0]), new LinkOption[0])) {
            Logger.debug((Object)("Can't submit because submit folder doesn't exist '" + this.ingestSubmitDir + "'"));
            rejectMessages.add("MessageSubmitFolderDoesNotExist '" + this.ingestSubmitDir + "'");
        }
        String submitSIPName = this.getSIPNameForSubmit(document);
        Path submitSIPPath = Paths.get(this.ingestSubmitDir, submitSIPName);
        if (Files.exists(submitSIPPath, new LinkOption[0])) {
            Logger.debug((Object)("Can't submit because submit SIP exists already in submit folder '" + this.ingestSubmitDir + "'"));
            rejectMessages.add("MessageSubmitSIPExistsAlreadyInSubmitFolder '" + submitSIPName + "'");
        }
        String sipName = document.getSIPName();
        Logger.info((Object)("Performing submit-check in SIP: '" + sipName + "'"));
        if (document.isReadOnly()) {
            Logger.debug((Object)("Can't submit because SIP is read-only: '" + sipName + "'"));
            rejectMessages.add("MessageSubmitSIPIsReadOnly '" + sipName + "'");
        }
        if (document.isLocked()) {
            Logger.debug((Object)("Can't submit because SIP is locked: '" + sipName + "'"));
            rejectMessages.add("MessageSubmitSIPIsLocked '" + sipName + "'");
        }
        Logger.debug((Object)("Checking all nodes in SIP: '" + sipName + "'"));
        for (String message : this.submitCheckRecursive(document.getStructureMap().getRoot())) {
            rejectMessages.add(message);
        }
        if (rejectMessages.isEmpty()) {
            Logger.debug((Object)"SIP is OK");
        } else {
            Logger.debug((Object)("Can't submit SIP because: " + rejectMessages));
        }
        return rejectMessages;
    }

    @Override
    public List<String> submit(Document document) throws Exception {
        List<String> rejectMessages = this.checkSubmission(document);
        if (!rejectMessages.isEmpty()) {
            return rejectMessages;
        }
        try {
            Logger.debug((Object)("Zipping to folder: '" + this.ingestSubmitDir + "' SIP: '" + document.getSIPName() + "'"));
            if (document.isZIPFile()) {
                FileUtil.copyToOverwriting((String)document.getOriginalSIPFolder(), (String)(this.ingestSubmitDir + File.separator + this.getSIPNameForSubmit(document)));
            } else {
                Zipper.zip((String)document.getOriginalSIPFolder(), (String)(this.ingestSubmitDir + File.separator + this.getSIPNameForSubmit(document)), (boolean)true);
            }
            document.unlockIfNecessary();
            FileUtil.delete((String)document.getOriginalSIPFolder());
            document.cleanupWorkingCopy();
        }
        catch (FileUtilExceptionListException e) {
            Logger.debug((Object)"Copying to submit folder failed", (Throwable)e);
            rejectMessages.add("Copying to submit folder failed: " + e.getMessage());
        }
        return rejectMessages;
    }

    @Override
    public List<String> checkIngestFeedback(String workspaceFolder) throws Exception {
        return null;
    }

    @Override
    public List<String> generateAIP(Document document) throws Exception {
        return null;
    }

    @Override
    public void confirmStorage(Document document) throws Exception {
    }

    private String getSIPNameForSubmit(Document mets) {
        String zipFileNameForSubmit = FileUtil.asFileNameWithoutExtension((String)mets.getSIPName()) + "_zip";
        String result = (String)(mets.isZIPFile() ? zipFileNameForSubmit : mets.getSIPName()) + ".zip";
        return result;
    }

    private List<String> submitCheckRecursive(NodeAbstract node) {
        Vector<String> rejectMessages = new Vector<String>();
        for (NodeAbstract n : node.getWithDescendants()) {
            for (String message : this.submitCheck(n)) {
                rejectMessages.add(message);
            }
        }
        return rejectMessages;
    }

    private List<String> submitCheck(NodeAbstract node) {
        Vector<String> rejectMessages = new Vector<String>();
        String pathString = node.getPathString();
        Logger.info((Object)("Performing submit-check for node: '" + pathString + "' (" + node.getAdmId() + ")"));
        if (!node.fileExists()) {
            rejectMessages.add("MessageSubmitNodeFileDoesNotExist '" + pathString + "'");
        }
        if (!node.canRead()) {
            rejectMessages.add("MessageSubmitNodeFileIsNotReadable '" + pathString + "'");
        }
        if (!node.canWrite()) {
            rejectMessages.add("MessageSubmitNodeFileIsNotWritable '" + pathString + "'");
        }
        if (node.getLevel().equals(LevelOfDescription.getUndefined())) {
            rejectMessages.add("MessageSubmitNodeHasUndefinedLevel '" + pathString + "'");
        }
        if (node.hasDynamicMetadataElementInstancesWhichAreMandatoryButNotSet()) {
            rejectMessages.add("MessageSubmitNodeMandatoryMetadataNotSet '" + pathString + "'");
        }
        if (rejectMessages.isEmpty()) {
            Logger.info((Object)"Node is OK");
        } else {
            Logger.info((Object)("Can't submit node because: " + rejectMessages));
        }
        return rejectMessages;
    }
}

