/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mets.amdsec;

import ch.docuteam.darc.mets.amdsec.AMDSection;
import ch.docuteam.darc.mets.amdsec.DigiprovAbstract;
import ch.docuteam.darc.mets.metshdr.Header;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.premis.Event;
import ch.docuteam.tools.exception.Exception;
import java.util.ArrayList;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import org.dom4j.Element;
import org.dom4j.Node;

public class DigiprovWithPremis
extends DigiprovAbstract {
    private static final String XMLNS_PREMIS = "info:lc/xmlns/premis-v2";
    private static final String PREMIS_Version = "2.2";
    protected SortedMap<String, ch.docuteam.darc.premis.Object> objects = new TreeMap<String, ch.docuteam.darc.premis.Object>();
    protected SortedMap<String, Event> events = new TreeMap<String, Event>();

    public DigiprovWithPremis(NodeAbstract node) {
        super(node);
        Element mdWrap = this.element.addElement("METS:mdWrap").addAttribute("MDTYPE", MDType);
        Element xmlData = mdWrap.addElement("METS:xmlData");
        xmlData.addElement("PREMIS:premis").addAttribute("xmlns:PREMIS", XMLNS_PREMIS).addAttribute("version", PREMIS_Version);
        ch.docuteam.darc.premis.Object newObject = this.addNewObject(node);
        this.addNewEventWithLinkObjectId(newObject.getId(), null, "Creation", "", "Success", "");
    }

    public DigiprovWithPremis(Header header) {
        super(header);
        Element mdWrap = this.element.addElement("METS:mdWrap").addAttribute("MDTYPE", MDType);
        Element xmlData = mdWrap.addElement("METS:xmlData");
        xmlData.addElement("PREMIS:premis").addAttribute("xmlns:PREMIS", XMLNS_PREMIS).addAttribute("version", PREMIS_Version);
        ch.docuteam.darc.premis.Object newObject = new ch.docuteam.darc.premis.Object(this, (Element)this.element.selectSingleNode("./METS:mdWrap[@MDTYPE='PREMIS']/METS:xmlData/PREMIS:premis"), header);
        this.objects.put(newObject.getId(), newObject);
    }

    private DigiprovWithPremis(AMDSection parent, Element digiprovElement) {
        super(parent, digiprovElement);
        Element premisElement = (Element)digiprovElement.selectSingleNode("./METS:mdWrap[@MDTYPE='PREMIS']/METS:xmlData/PREMIS:premis");
        if (premisElement == null) {
            Exception.remember((String)("Couldn't locate node 'PREMIS:premis' in node 'METS:digiprovMD' with id=" + this.id));
            return;
        }
        for (ch.docuteam.darc.premis.Object object : ch.docuteam.darc.premis.Object.parse(this, premisElement)) {
            this.objects.put(object.getId(), object);
        }
        for (Event event : Event.parse(this, premisElement)) {
            this.events.put(event.getId(), event);
        }
    }

    protected static List<DigiprovWithPremis> parse(AMDSection parent) {
        ArrayList<DigiprovWithPremis> fileList = new ArrayList<DigiprovWithPremis>();
        for (Object o : parent.getElement().selectNodes("./METS:digiprovMD")) {
            fileList.add(new DigiprovWithPremis(parent, (Element)o));
        }
        return fileList;
    }

    public ch.docuteam.darc.premis.Object getObject(String id) {
        return (ch.docuteam.darc.premis.Object)this.objects.get(id);
    }

    public List<ch.docuteam.darc.premis.Object> getObjects() {
        return new ArrayList<ch.docuteam.darc.premis.Object>(this.objects.values());
    }

    public ch.docuteam.darc.premis.Object getObject(Integer i) {
        return this.getObjects().get(i);
    }

    public ch.docuteam.darc.premis.Object getLastObject() {
        Integer objectCount = this.objects.size();
        if (objectCount <= 0) {
            return null;
        }
        return this.getObject(objectCount - 1);
    }

    public Event getEvent(String id) {
        return (Event)this.events.get(id);
    }

    public List<Event> getEvents() {
        return new ArrayList<Event>(this.events.values());
    }

    public Event getEvent(Integer i) {
        return this.getEvents().get(i);
    }

    public Event getLastEvent() {
        Integer eventCount = this.events.size();
        if (eventCount <= 0) {
            return null;
        }
        return this.getEvents().get(eventCount - 1);
    }

    public ch.docuteam.darc.premis.Object addNewObject(NodeAbstract node) {
        ch.docuteam.darc.premis.Object newObject = new ch.docuteam.darc.premis.Object(this, (Element)this.element.selectSingleNode("./METS:mdWrap[@MDTYPE='PREMIS']/METS:xmlData/PREMIS:premis"), node);
        this.objects.put(newObject.getId(), newObject);
        this.document.setIsModified();
        return newObject;
    }

    public ch.docuteam.darc.premis.Object addNewObjectWithRelationship(NodeAbstract node, Event event) {
        ch.docuteam.darc.premis.Object newObject = this.addNewObject(node);
        newObject.addRelationships(event);
        return newObject;
    }

    public Event addNewEvent(String type, String detail, String outcome, String outcomeDetail) {
        return this.addNewEvent(null, type, detail, outcome, outcomeDetail);
    }

    public Event addNewEvent(String date, String type, String detail, String outcome, String outcomeDetail) {
        return this.addNewEventWithLinkObjectId(this.getLastObject().getId(), date, type, detail, outcome, outcomeDetail);
    }

    public Event addNewFirstEvent(String type, String detail, String outcome, String outcomeDetail) {
        return this.addNewFirstEvent(null, type, detail, outcome, outcomeDetail);
    }

    public Event addNewFirstEvent(String date, String type, String detail, String outcome, String outcomeDetail) {
        Event newEvent = this.addNewEvent(date, type, detail, outcome, outcomeDetail);
        Element parentElement = newEvent.getElement().getParent();
        int indexOfLastObject = -1;
        for (int i = parentElement.content().size() - 1; i >= 0; --i) {
            if (!((Node)parentElement.content().get(i)).hasContent() || !"PREMIS:object".equals(((Element)parentElement.content().get(i)).getQualifiedName())) continue;
            indexOfLastObject = i;
            break;
        }
        newEvent.getElement().detach();
        parentElement.content().add(indexOfLastObject + 1, newEvent.getElement());
        return newEvent;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("[AMDSectionDigiprov:id=" + this.id);
        for (ch.docuteam.darc.premis.Object object : this.objects.values()) {
            buf.append("\n\t\t").append(object.toString());
        }
        for (Event event : this.events.values()) {
            buf.append("\n\t\t").append(event.toString());
        }
        buf.append("]");
        return buf.toString();
    }

    private Event addNewEventWithLinkObjectId(String linkObjectId, String date, String type, String detail, String outcome, String outcomeDetail) {
        Event newEvent = new Event(this, (Element)this.element.selectSingleNode("./METS:mdWrap[@MDTYPE='PREMIS']/METS:xmlData/PREMIS:premis"), linkObjectId, date, type, detail, outcome, outcomeDetail);
        this.events.put(newEvent.getId(), newEvent);
        this.document.setIsModified();
        return newEvent;
    }

    static {
        MDType = "PREMIS";
    }
}

