/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.office.utils;

import com.sun.star.beans.PropertyValue;
import com.sun.star.beans.UnknownPropertyException;
import com.sun.star.beans.XPropertySet;
import com.sun.star.lang.WrappedTargetException;
import com.sun.star.uno.Exception;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.local.office.utils.Lo;
import org.jodconverter.local.office.utils.WrappedUnoException;

public final class Props {
    public static @NonNull Object getProperty(@NonNull Object obj, @NonNull String propName) {
        return Props.getProperty(Lo.qi(XPropertySet.class, obj), propName);
    }

    public static @NonNull Object getProperty(@NonNull XPropertySet props, @NonNull String propName) {
        try {
            return props.getPropertyValue(propName);
        }
        catch (UnknownPropertyException | WrappedTargetException ex) {
            throw new WrappedUnoException(ex.getMessage(), (Exception)ex);
        }
    }

    public static @NonNull PropertyValue makeProperty(@NonNull String name, @NonNull Object value) {
        PropertyValue prop = new PropertyValue();
        prop.Name = name;
        prop.Value = value;
        return prop;
    }

    public static @NonNull PropertyValue[] makeProperties(@NonNull String name, @NonNull Object value) {
        return new PropertyValue[]{Props.makeProperty(name, value)};
    }

    public static @NonNull PropertyValue[] makeProperties(@NonNull String name1, @NonNull Object value1, @NonNull String name2, @NonNull Object value2) {
        return new PropertyValue[]{Props.makeProperty(name1, value1), Props.makeProperty(name2, value2)};
    }

    public static @NonNull PropertyValue[] makeProperties(@NonNull String[] names, @NonNull Object[] values) {
        if (names.length != values.length) {
            throw new IllegalArgumentException("Mismatch in lengths of names and values");
        }
        PropertyValue[] props = new PropertyValue[names.length];
        for (int i = 0; i < names.length; ++i) {
            props[i] = Props.makeProperty(names[i], values[i]);
        }
        return props;
    }

    private Props() {
        throw new AssertionError((Object)"Utility class must not be instantiated");
    }
}

