/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model;

import java.io.Serializable;
import java.util.Calendar;

public class DividedDate
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Integer day;
    private Integer month;
    private Integer year;
    private Calendar calendar;
    boolean noDate;
    boolean errorDate;

    public DividedDate() {
        this.calendar = Calendar.getInstance();
        this.calendar.setLenient(false);
    }

    public DividedDate(Calendar calendar) {
        this.calendar = calendar;
        this.noDate = false;
        if (calendar != null && calendar.getTimeInMillis() != 0L) {
            this.calendar.setLenient(false);
            this.day = calendar.get(5);
            this.month = calendar.get(2) + 1;
            this.year = calendar.get(1);
        } else {
            this.calendar = Calendar.getInstance();
            this.calendar.setLenient(false);
            this.calendar.setTimeInMillis(0L);
            this.day = 0;
            this.month = 0;
            this.year = 0;
        }
    }

    public DividedDate(String strDividedDate) {
        this.calendar = Calendar.getInstance();
        this.calendar.setLenient(false);
        String[] splitDate = strDividedDate.split("-");
        if (splitDate.length != 3) {
            this.day = 0;
            this.month = 0;
            this.year = 0;
            this.noDate = true;
        } else {
            try {
                String year = splitDate[0];
                this.year = year != null && year.length() == 4 ? Integer.parseInt(year) : 0;
                String month = splitDate[1];
                this.month = month != null && month.length() == 2 ? Integer.parseInt(month) : 0;
                String day = splitDate[2];
                if (day != null && day.length() == 2) {
                    this.setDay(Integer.parseInt(day));
                } else {
                    this.setDay(0);
                }
            }
            catch (NumberFormatException e) {
                this.day = 0;
                this.month = 0;
                this.year = 0;
                this.noDate = true;
            }
        }
    }

    public Integer getDay() {
        return this.day;
    }

    public void setDay(Integer day) {
        this.day = day;
        if (day == 0) {
            this.calendar.setTimeInMillis(0L);
            this.noDate = true;
            return;
        }
        try {
            this.calendar.set(this.year, this.month - 1, this.day);
            this.calendar.getTime();
            this.noDate = false;
            this.errorDate = false;
        }
        catch (Exception e) {
            this.errorDate = true;
        }
    }

    public Integer getMonth() {
        return this.month;
    }

    public void setMonth(Integer month) {
        this.month = month;
        if (month == 0) {
            this.calendar.setTimeInMillis(0L);
            this.noDate = true;
            return;
        }
        try {
            this.calendar.set(this.year, this.month - 1, this.day);
            this.calendar.getTime();
            this.noDate = false;
            this.errorDate = false;
        }
        catch (Exception e) {
            this.errorDate = true;
        }
    }

    public Integer getYear() {
        return this.year;
    }

    public void setYear(Integer year) {
        this.year = year;
        if (year == 0) {
            this.calendar.setTimeInMillis(0L);
            this.noDate = true;
            return;
        }
        try {
            this.calendar.set(this.year, this.month - 1, this.day);
            this.calendar.getTime();
            this.noDate = false;
            this.errorDate = false;
        }
        catch (Exception e) {
            this.errorDate = true;
        }
    }

    public Calendar getCalendar() {
        return this.calendar;
    }

    public void setCalendar(Calendar calendar) {
        this.calendar = calendar;
    }

    public String toString() {
        if (this.day == null || this.month == null || this.year == null) {
            return "0";
        }
        if (this.noDate) {
            return "0";
        }
        if (this.errorDate) {
            return "errorDate";
        }
        return String.valueOf(this.calendar.getTimeInMillis());
    }

    public String getFullDate() {
        if (this.day == null || this.month == null || this.year == null) {
            return "";
        }
        if (this.noDate) {
            return "";
        }
        String dayString = this.getFullPeriodSyntax(this.day);
        String monthString = this.getFullPeriodSyntax(this.month);
        return this.year + "-" + monthString + "-" + dayString;
    }

    private String getFullPeriodSyntax(Integer period) {
        String periodString = "" + period;
        if (period < 10) {
            periodString = "0" + period;
        }
        return periodString;
    }

    public String getInputDateTagFormat() {
        if (this.day == null || this.month == null || this.year == null) {
            return "dd.mm.yyyy";
        }
        if (this.noDate) {
            return "dd.mm.yyyy";
        }
        String day = this.getFullPeriodSyntax(this.day);
        String month = this.getFullPeriodSyntax(this.month);
        return day + "." + month + "." + this.year;
    }

    public boolean isValidDate() {
        return !this.noDate;
    }
}

