/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.xml;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.model.annotation.emailData;
import com.exlibris.core.infra.svc.api.common.DateHandler;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.beans.PropertyEditorManager;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.apache.xerces.parsers.DOMParser;
import org.dom4j.Document;
import org.dom4j.DocumentFactory;
import org.dom4j.DocumentHelper;
import org.dom4j.Node;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlUtil {
    private static ExLogger logger = ExLogger.getExLogger(XmlUtil.class);

    public static Map getPrefixesAndNsInUse(String docStr) throws Exception {
        return XmlUtil.getPrefixesAndNsInUse(XmlUtil.toDoc(docStr));
    }

    private static Map getPrefixesAndNsInUse(org.jdom.Document doc) throws Exception {
        HashMap map = new HashMap();
        XmlUtil.extractNsInUse(doc.getRootElement(), map);
        return map;
    }

    private static void extractNsInUse(Element element, Map nsMap) {
        Element elem = element;
        nsMap.put(elem.getNamespaceURI(), elem.getNamespacePrefix());
        List attributes = elem.getAttributes();
        if (!attributes.isEmpty()) {
            for (Attribute attribute : attributes) {
                Namespace attributeNamespace = attribute.getNamespace();
                if (attributeNamespace == Namespace.NO_NAMESPACE) continue;
                nsMap.put(attributeNamespace.getURI(), attributeNamespace.getPrefix());
            }
        }
        List content = elem.getChildren();
        for (Object o : content) {
            Element child = (Element)o;
            XmlUtil.extractNsInUse(child, nsMap);
        }
    }

    public static String replcaeNsPrefix(String docStr, Map nsmap) throws Exception {
        org.jdom.Document doc = XmlUtil.toDoc(docStr);
        Element root = doc.getRootElement();
        XmlUtil.replaceNsPrefix(root, nsmap);
        Iterator nsitr = root.getAdditionalNamespaces().iterator();
        while (nsitr.hasNext()) {
            Namespace ns = (Namespace)nsitr.next();
            root.removeNamespaceDeclaration(ns);
            nsitr = root.getAdditionalNamespaces().iterator();
        }
        for (String uri : nsmap.keySet()) {
            String urins = (String)nsmap.get(uri);
            if (uri == null || uri.length() <= 0 || urins == null || urins.length() <= 0) continue;
            root.addNamespaceDeclaration(Namespace.getNamespace((String)urins, (String)uri));
        }
        XMLOutputter xo = new XMLOutputter();
        return xo.outputString(doc);
    }

    private static void replaceNsPrefix(Element element, Map replcae) {
        List attributes;
        String defPref;
        Element child = element;
        Namespace ns = child.getNamespace();
        if (ns != null && ns != Namespace.NO_NAMESPACE && (defPref = (String)replcae.get(ns.getURI())) != null && !defPref.equals(ns.getPrefix())) {
            child.removeNamespaceDeclaration(ns);
            Namespace defns = Namespace.getNamespace((String)defPref, (String)ns.getURI());
            child.setNamespace(defns);
        }
        if (!(attributes = child.getAttributes()).isEmpty()) {
            for (Attribute attribute : attributes) {
                String defPref2;
                Namespace attributeNamespace = attribute.getNamespace();
                if (attributeNamespace == Namespace.NO_NAMESPACE || (defPref2 = (String)replcae.get(attributeNamespace.getURI())) == null || defPref2.equals(attributeNamespace.getPrefix())) continue;
                child.removeNamespaceDeclaration(attributeNamespace);
                Namespace defns = Namespace.getNamespace((String)defPref2, (String)attributeNamespace.getURI());
                child.setNamespace(defns);
            }
        }
        List content = child.getChildren();
        for (Object o : content) {
            Element child1 = (Element)o;
            XmlUtil.replaceNsPrefix(child1, replcae);
        }
    }

    public static org.jdom.Document toDoc(String xml) throws Exception {
        org.jdom.Document document = null;
        SAXBuilder parser = new SAXBuilder();
        document = parser.build((Reader)new StringReader(xml));
        return document;
    }

    public static Document parseDocument(String xml) {
        Document doc = null;
        try {
            doc = DocumentHelper.parseText((String)xml);
        }
        catch (Exception e) {
            logger.warn((Object)e, e, new String[0]);
            return null;
        }
        return doc;
    }

    public static List getXPathValues(String xml, String xpath) {
        Document doc = XmlUtil.parseDocument(xml);
        if (doc == null) {
            return null;
        }
        return XmlUtil.getXPathValues(doc, xpath);
    }

    public static List getXPathValues(Document dom4jDoc, String xpath) {
        return dom4jDoc.selectNodes(xpath);
    }

    public static Node getXPathValue(Document dom4jDoc, String xpath) {
        return dom4jDoc.selectSingleNode(xpath);
    }

    public static String runXSL(String xml, String xslFileContent) {
        return XmlUtil.runXSL(xml, xslFileContent, null);
    }

    public static void runXSL(String xmlString, Writer output, String xslStr) throws TransformerException {
        StreamSource xmlSource = new StreamSource(new StringReader(xmlString));
        StreamSource xslSource = new StreamSource(new StringReader(xslStr));
        TransformerFactory transFact = TransformerFactory.newInstance();
        Transformer trans = transFact.newTransformer(xslSource);
        trans.setOutputProperty("omit-xml-declaration", "no");
        trans.transform(xmlSource, new StreamResult(output));
    }

    public static String runXSL(String xml, String xslFileContent, HashMap<String, String> params) {
        if (xml == null || xslFileContent == null) {
            return null;
        }
        StringWriter outputXML = null;
        try {
            DOMParser parser = new DOMParser();
            InputSource inputSource = new InputSource(new StringReader(xml));
            parser.parse(inputSource);
            org.w3c.dom.Document doc = parser.getDocument();
            DOMSource xmlSource = new DOMSource(doc);
            outputXML = new StringWriter();
            StreamResult result = new StreamResult(outputXML);
            StreamSource xslSource = new StreamSource(new StringReader(xslFileContent));
            Transformer trans = TransformerFactory.newInstance().newTransformer(xslSource);
            if (params != null) {
                for (String key : params.keySet()) {
                    String value = params.get(key);
                    trans.setParameter(key, value);
                }
            }
            trans.transform(xmlSource, result);
        }
        catch (Exception e) {
            logger.warn((Object)e, e, new String[0]);
            return null;
        }
        return outputXML.toString();
    }

    public static String getBeanAsXML(Object beanObject) {
        return XmlUtil.getBeanAsXML(beanObject, false);
    }

    public static String getBeanAsXML(Object beanObject, boolean emailData2) {
        Document document = DocumentFactory.getInstance().createDocument();
        org.dom4j.Element element = XmlUtil.getBeanAsXML(beanObject, new ArrayList(), emailData2);
        if (element == null) {
            return null;
        }
        document.setRootElement(element);
        return document.asXML();
    }

    private static org.dom4j.Element getBeanAsXML(Object beanObject, List stack) {
        return XmlUtil.getBeanAsXML(beanObject, stack, false);
    }

    private static org.dom4j.Element getBeanAsXML(Object beanObject, List stack, boolean emailData2) {
        PropertyEditor editor;
        BeanInfo beanInfo;
        if (beanObject == null) {
            return null;
        }
        Class<?> beanClass = beanObject.getClass();
        try {
            beanInfo = Introspector.getBeanInfo(beanClass);
        }
        catch (IntrospectionException e) {
            return null;
        }
        BeanDescriptor beanDescriptor = beanInfo.getBeanDescriptor();
        if (beanDescriptor == null) {
            return null;
        }
        String beanName = beanDescriptor.getName();
        if (beanName.equals("class") && beanClass.equals(Class.class)) {
            return null;
        }
        org.dom4j.Element element = DocumentFactory.getInstance().createElement(beanName);
        if (stack.contains(beanObject)) {
            return element;
        }
        if (emailData2) {
            if (beanObject instanceof Enum) {
                element.setText(((Enum)beanObject).toString());
                return element;
            }
            if (beanObject instanceof Date) {
                element.setText(DateHandler.formatDateAndTime((Date)beanObject));
                return element;
            }
            if (beanObject instanceof Calendar) {
                element.setText(DateHandler.formatDateAndTime(((Calendar)beanObject).getTime()));
                return element;
            }
        }
        if ((editor = XmlUtil.getObjectEditor(beanObject)) != null) {
            String propertyTextValue = editor.getAsText();
            element.addText(propertyTextValue);
            return element;
        }
        if (beanObject instanceof Number) {
            element.setText("" + ((Number)beanObject).intValue());
            return element;
        }
        if (beanObject instanceof Collection) {
            Collection collection = (Collection)beanObject;
            Iterator iterator = collection.iterator();
            if (iterator == null) {
                return element;
            }
            while (iterator.hasNext()) {
                Object collectionItem = iterator.next();
                stack.add(beanObject);
                org.dom4j.Element setItem = XmlUtil.getBeanAsXML(collectionItem, stack, emailData2);
                stack.remove(beanObject);
                if (setItem == null) continue;
                setItem.setName("value");
                element.add(setItem);
            }
            return element;
        }
        if (beanObject instanceof Map) {
            Map map = (Map)beanObject;
            Iterator iterator = map.entrySet().iterator();
            if (iterator == null) {
                return element;
            }
            element = DocumentFactory.getInstance().createElement(beanName);
            while (iterator.hasNext()) {
                org.dom4j.Element keyElement;
                Map.Entry entry = iterator.next();
                Object keyObject = entry.getKey();
                Object valueObject = entry.getValue();
                PropertyEditor propertyEditor = null;
                propertyEditor = XmlUtil.getObjectEditor(keyObject);
                org.dom4j.Element mapEntry = DocumentFactory.getInstance().createElement("map_entry");
                element.add(mapEntry);
                if (propertyEditor != null) {
                    keyElement = DocumentFactory.getInstance().createElement("key");
                    keyElement.setText(propertyEditor.getAsText());
                    mapEntry.add(keyElement);
                } else {
                    stack.add(beanObject);
                    keyElement = XmlUtil.getBeanAsXML(keyObject, stack, emailData2);
                    stack.remove(beanObject);
                    keyElement.setName("key");
                    mapEntry.add(keyElement);
                }
                propertyEditor = XmlUtil.getObjectEditor(valueObject);
                if (propertyEditor != null) {
                    org.dom4j.Element valueElement = DocumentFactory.getInstance().createElement("value");
                    valueElement.setText(propertyEditor.getAsText());
                    mapEntry.add(valueElement);
                    continue;
                }
                stack.add(beanObject);
                keyElement = XmlUtil.getBeanAsXML(valueObject, stack, emailData2);
                stack.remove(beanObject);
                keyElement.setName("value");
                mapEntry.add(keyElement);
            }
            return element;
        }
        PropertyDescriptor[] pds = beanInfo.getPropertyDescriptors();
        for (int i = 0; i < pds.length; ++i) {
            PropertyDescriptor pd = pds[i];
            Object propertyValue = null;
            String propertyName = pd.getName();
            Class<?> propertyClass = pd.getPropertyType();
            if (propertyName.equals("class") && propertyClass.equals(Class.class)) continue;
            Method getter = pd.getReadMethod();
            if (getter != null) {
                if (emailData2 && !getter.isAnnotationPresent(emailData.class)) continue;
                try {
                    Object[] argsNone = new Object[]{};
                    propertyValue = getter.invoke(beanObject, argsNone);
                }
                catch (Exception e) {
                    continue;
                }
            }
            stack.add(beanObject);
            org.dom4j.Element childElement = XmlUtil.getBeanAsXML(propertyValue, stack, emailData2);
            stack.remove(beanObject);
            if (childElement == null) continue;
            childElement.setName(propertyName);
            element.add(childElement);
        }
        return element;
    }

    private static PropertyEditor getObjectEditor(Object bean) {
        if (bean == null) {
            return null;
        }
        PropertyEditor editor = PropertyEditorManager.findEditor(bean.getClass());
        if (editor == null) {
            return null;
        }
        editor.setValue(bean);
        return editor;
    }

    public static void parseXmlWithSax(String xmlStr, DefaultHandler handler, boolean validating) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(validating);
            factory.newSAXParser().parse(new InputSource(new StringReader(xmlStr)), handler);
        }
        catch (SAXException sAXException) {
        }
        catch (ParserConfigurationException parserConfigurationException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String createXPath(String op, String nodeName, String attribute, String[] values) {
        String[] attributes = new String[values.length];
        for (int i = 0; i < values.length; ++i) {
            attributes[i] = attribute;
        }
        return XmlUtil.createXPath(op, nodeName, attributes, values);
    }

    public static String createXPath(String op, String nodeName, String[] attributes, String[] values) {
        if (nodeName == null || nodeName.trim().length() == 0 || attributes == null || values == null || attributes.length != values.length) {
            return null;
        }
        StringBuffer xPath = new StringBuffer("//").append(nodeName).append("[");
        for (int i = 0; i < attributes.length; ++i) {
            try {
                if (i > 0) {
                    xPath.append(" ").append(op).append(" ");
                }
                xPath.append("@").append(attributes[i]).append("='").append(values[i]).append("'");
                continue;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        xPath.append("]");
        return xPath.toString();
    }
}

