/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.repository.ifc;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.repository.ifc.CoreMetadataServices;
import com.exlibris.core.repository.ifc.CoreRepositoryServices;
import com.exlibris.digitool.common.dnx.DnxDocument;
import com.exlibris.digitool.common.dnx.DnxDocumentFactory;
import com.exlibris.digitool.common.dnx.DnxDocumentHelper;
import com.exlibris.repository.persistence.digitalentity.HDeControl;
import com.exlibris.repository.persistence.digitalentity.HDeMetadata;
import com.exlibris.repository.persistence.digitalentity.HDeStreamRef;
import com.exlibris.repository.persistence.digitalentity.MetadataWithPID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

public class HPaData {
    private static ExLogger logger = ExLogger.getExLogger(HPaData.class, "TSK");
    private Map<String, HDeControl> ies;
    private Map<String, HDeMetadata> ieDnxs = new HashMap<String, HDeMetadata>();
    private Map<String, HDeMetadata> fileDnxs;
    private Map<String, List<HDeMetadata>> fileSources;
    private Map<String, HDeMetadata> fileDCs;
    private Map<String, HDeMetadata> repDnxs = new HashMap<String, HDeMetadata>();
    private Map<String, List<HDeMetadata>> repSources;
    private Map<String, HDeStreamRef> streamRefs;
    private Map<String, Map<String, HDeControl>> reps;
    private Map<String, Map<String, HDeControl>> files;
    private Map<String, HDeMetadata> ieCMSs;
    private Map<String, HDeMetadata> arMDs;
    private Map<String, String> metsMDs;
    private CoreMetadataServices mdManager = null;
    private CoreRepositoryServices repositoryManager = null;

    public HPaData() {
        this.fileDnxs = new HashMap<String, HDeMetadata>();
        this.setFileSources(new HashMap<String, List<HDeMetadata>>());
        this.setRepSources(new HashMap<String, List<HDeMetadata>>());
        this.setFileDCs(new HashMap<String, HDeMetadata>());
        this.streamRefs = new HashMap<String, HDeStreamRef>();
        this.ies = new HashMap<String, HDeControl>();
        this.reps = new HashMap<String, Map<String, HDeControl>>();
        this.files = new HashMap<String, Map<String, HDeControl>>();
        this.ieCMSs = new HashMap<String, HDeMetadata>();
        this.arMDs = new HashMap<String, HDeMetadata>();
        this.metsMDs = new HashMap<String, String>();
    }

    public void loadReps(String iePid) {
        if (this.reps.get(iePid) != null) {
            return;
        }
        HashMap<String, HDeControl> repControls = new HashMap<String, HDeControl>();
        List<HDeControl> repsList = this.getCoreRepositoryManager().getReps(iePid);
        this.loadRepDnxs(repsList);
        this.loadRepSources(repsList);
        for (HDeControl rep : repsList) {
            DnxDocument repDnxDoc = DnxDocumentFactory.getInstance().parse(this.getRepDnxMetadata(rep.getPid()).getValue());
            DnxDocumentHelper documentHelper = new DnxDocumentHelper(repDnxDoc);
            int revisionNumber = StringUtils.isBlank((String)documentHelper.getGeneralRepCharacteristics().getRevisionNumber()) ? 0 : Integer.valueOf(documentHelper.getGeneralRepCharacteristics().getRevisionNumber());
            rep.setRevision(revisionNumber);
            repControls.put(rep.getPid(), rep);
        }
        this.reps.put(iePid, repControls);
        logger.info("Loaded " + repControls.size() + " representations for: " + iePid);
    }

    private void loadRepSources(List<HDeControl> reps) {
        ArrayList<String> repPids = new ArrayList<String>();
        for (HDeControl rep : reps) {
            repPids.add(rep.getPid());
            this.repSources.put(rep.getPid(), new ArrayList());
        }
        List<MetadataWithPID> mds = this.getCoreMetadataManager().getSourceMDsByPidsOneFlush(repPids);
        for (String pid : repPids) {
            for (MetadataWithPID md : mds) {
                if (!md.getPid().equals(pid)) continue;
                this.repSources.get(pid).add(md.getMetadata());
            }
        }
    }

    public void loadFilesIncludingDeleted(String iePid) {
        if (this.files.get(iePid) != null) {
            return;
        }
        HashMap<String, HDeControl> repControls = new HashMap<String, HDeControl>();
        List<HDeControl> repsList = this.getCoreRepositoryManager().getReps(iePid);
        this.loadRepDnxs(repsList);
        this.loadRepSources(repsList);
        for (HDeControl rep : repsList) {
            repControls.put(rep.getPid(), rep);
            Map<String, HDeControl> fileControls = this.loadFilesByRep(rep.getPid(), true);
            this.files.put(rep.getPid(), fileControls);
            logger.info("Loaded " + fileControls.size() + " files for: " + rep.getPid() + " (" + iePid + ")");
        }
        this.reps.put(iePid, repControls);
        logger.info("Loaded " + repControls.size() + " representations for: " + iePid);
    }

    public void loadFiles(String iePid) {
        if (this.files.get(iePid) != null) {
            return;
        }
        HashMap<String, HDeControl> repControls = new HashMap<String, HDeControl>();
        List<HDeControl> repsList = this.getCoreRepositoryManager().getReps(iePid);
        this.loadRepDnxs(repsList);
        this.loadRepSources(repsList);
        for (HDeControl rep : repsList) {
            repControls.put(rep.getPid(), rep);
            Map<String, HDeControl> fileControls = this.loadFilesByRep(rep.getPid(), false);
            this.files.put(rep.getPid(), fileControls);
            logger.info("Loaded " + fileControls.size() + " files for: " + rep.getPid() + " (" + iePid + ")");
        }
        this.reps.put(iePid, repControls);
        logger.info("Loaded " + repControls.size() + " representations for: " + iePid);
    }

    private Map<String, HDeControl> loadFilesByRep(String repPid, boolean includeDeleted) {
        HashMap<String, HDeControl> fileControls = new HashMap<String, HDeControl>();
        ArrayList<String> filePids = new ArrayList<String>();
        List<HDeControl> filesList = null;
        filesList = includeDeleted ? this.getCoreRepositoryManager().getFilesIncludingMarked(repPid) : this.getCoreRepositoryManager().getFiles(repPid);
        for (HDeControl file : filesList) {
            fileControls.put(file.getPid(), file);
            filePids.add(file.getPid());
        }
        this.loadFileDnxs(filePids);
        this.loadFilesDCs(filePids);
        this.loadFilesSourcess(filePids);
        this.loadStreamRefs(filePids);
        return fileControls;
    }

    public void loadRepsByPid(String iePid, List<String> repPidList) {
        if (this.reps.get(iePid) != null) {
            return;
        }
        HashMap<String, HDeControl> repControls = new HashMap<String, HDeControl>();
        List<HDeControl> repsList = this.getCoreRepositoryManager().getControlsByPidsOneFlush(repPidList);
        this.loadRepDnxs(repsList);
        this.loadRepSources(repsList);
        for (HDeControl control : repsList) {
            DnxDocument repDnxDoc = DnxDocumentFactory.getInstance().parse(this.getRepDnxMetadata(control.getPid()).getValue());
            DnxDocumentHelper documentHelper = new DnxDocumentHelper(repDnxDoc);
            int revisionNumber = StringUtils.isBlank((String)documentHelper.getGeneralRepCharacteristics().getRevisionNumber()) ? 0 : Integer.valueOf(documentHelper.getGeneralRepCharacteristics().getRevisionNumber());
            control.setRevision(revisionNumber);
            repControls.put(control.getPid(), control);
        }
        this.reps.put(iePid, repControls);
        logger.info("Loaded " + repControls.size() + " representations for: " + iePid);
    }

    public void loadFilesByRepPid(String iePid, List<String> repPidList, boolean includeDeleted) {
        if (this.files.get(repPidList.get(0)) != null) {
            return;
        }
        for (String repPid : repPidList) {
            Map<String, HDeControl> fileControls = this.loadFilesByRep(repPid, includeDeleted);
            this.files.put(repPid, fileControls);
            logger.info("Loaded " + fileControls.size() + " files for: " + repPid + " (" + iePid + ")");
        }
    }

    public void loadFilesByPid(String repPid, List<String> filePidList) {
        if (this.files.get(repPid) != null) {
            return;
        }
        HashMap<String, HDeControl> fileControls = new HashMap<String, HDeControl>();
        List<HDeControl> fileControlList = this.getCoreRepositoryManager().getControlsByPidsOneFlush(filePidList);
        for (HDeControl control : fileControlList) {
            fileControls.put(control.getPid(), control);
        }
        this.loadFileDnxs(filePidList);
        this.loadFilesSourcess(filePidList);
        this.loadFilesDCs(filePidList);
        this.loadStreamRefs(filePidList);
        this.files.put(repPid, fileControls);
    }

    public void loadAll(String iePid) {
        this.loadIE(iePid);
        this.loadFiles(iePid);
    }

    public void loadIE(String iePid) {
        if (this.ies.get(iePid) != null) {
            return;
        }
        HDeControl ie = this.getCoreRepositoryManager().getControlByPid(iePid);
        this.ies.put(ie.getPid(), ie);
        this.loadIeDnx(ie);
        logger.info((Object)"Loaded ie", iePid);
    }

    public void loadFilesDCs(List<String> filesPids) {
        List<MetadataWithPID> mds = this.getCoreMetadataManager().getDCByPidsOneFlush(filesPids);
        for (MetadataWithPID md : mds) {
            this.getFileDCs().put(md.getPid(), md.getMetadata());
        }
    }

    public void loadFilesSourcess(List<String> filesPids) {
        List<MetadataWithPID> mds = this.getCoreMetadataManager().getSourceMDsByPidsOneFlush(filesPids);
        for (String pid : filesPids) {
            this.fileSources.put(pid, new ArrayList());
            for (MetadataWithPID md : mds) {
                if (!md.getPid().equals(pid)) continue;
                this.fileSources.get(pid).add(md.getMetadata());
            }
        }
    }

    public void loadFileDnxs(List<String> filesPids) {
        List<HDeMetadata> mds = this.getCoreMetadataManager().getDnxsByPidsOneFlush(filesPids);
        for (HDeMetadata md : mds) {
            this.fileDnxs.put(md.getMid().replace("DNX_", ""), md);
        }
    }

    public void loadRepDnxs(List<HDeControl> reps) {
        ArrayList<String> repPids = new ArrayList<String>();
        for (HDeControl rep : reps) {
            repPids.add(rep.getPid());
        }
        List<HDeMetadata> mds = this.getCoreMetadataManager().getDnxsByPidsOneFlush(repPids);
        for (HDeMetadata md : mds) {
            this.repDnxs.put(md.getMid().replace("DNX_", ""), md);
        }
    }

    public void loadIeDnx(HDeControl ie) {
        ArrayList<String> iePids = new ArrayList<String>();
        iePids.add(ie.getPid());
        List<HDeMetadata> mds = this.getCoreMetadataManager().getDnxsByPidsOneFlush(iePids);
        for (HDeMetadata md : mds) {
            this.ieDnxs.put(md.getMid().replace("DNX_", ""), md);
        }
    }

    public void loadIeCMS(String iePid) {
        HDeMetadata mds = this.getCoreMetadataManager().getCMSByPid(iePid);
        if (mds != null) {
            this.ieCMSs.put(iePid, mds);
        }
    }

    public void loadARMDs() {
        List<HDeMetadata> allSharedMD = this.getCoreMetadataManager().findAllARMD();
        if (allSharedMD != null) {
            for (HDeMetadata hDeMetadata : allSharedMD) {
                this.arMDs.put(hDeMetadata.getMid(), hDeMetadata);
            }
        }
    }

    public void loadStreamRefs(List<String> filesPids) {
        List<HDeStreamRef> streamRefsList = this.getCoreRepositoryManager().getStreamRefsByPidsOneFlush(filesPids);
        for (HDeStreamRef streamRef : streamRefsList) {
            this.streamRefs.put(streamRef.getPid(), streamRef);
        }
    }

    public List<HDeStreamRef> getStreamRefs() {
        return new ArrayList<HDeStreamRef>(this.streamRefs.values());
    }

    public List<HDeMetadata> getFileDnxMetadata() {
        return new ArrayList<HDeMetadata>(this.fileDnxs.values());
    }

    public HDeMetadata getFileDnxMetadata(String pid) {
        return this.fileDnxs.get(pid);
    }

    public List<HDeMetadata> getRepDnxMetadata() {
        return new ArrayList<HDeMetadata>(this.repDnxs.values());
    }

    public HDeMetadata getRepDnxMetadata(String pid) {
        return this.repDnxs.get(pid);
    }

    public void setFileDnxMetadata(String pid, HDeMetadata dnx) {
        this.fileDnxs.put(pid, dnx);
    }

    public HDeStreamRef getStreamRef(String pid) {
        return this.streamRefs.get(pid);
    }

    public HDeControl getIEByPid(String pid) {
        return this.ies.get(pid);
    }

    public Map<String, HDeMetadata> getIeCMSs() {
        return this.ieCMSs;
    }

    public Map<String, HDeMetadata> getARMDs() {
        return this.arMDs;
    }

    public void setStreamRef(String pid, HDeStreamRef streamRef) {
        this.streamRefs.put(pid, streamRef);
    }

    public List<HDeControl> getReps(String pid) {
        Map<String, HDeControl> map = this.reps.get(pid);
        return new ArrayList<HDeControl>(map.values());
    }

    public List<HDeControl> getFiles(String iePid) {
        HashMap<String, HDeControl> filesMap = new HashMap<String, HDeControl>();
        Map<String, HDeControl> map = this.reps.get(iePid);
        Set<String> repPids = map.keySet();
        for (String repPid : repPids) {
            filesMap.putAll(this.files.get(repPid));
        }
        return new ArrayList<HDeControl>(filesMap.values());
    }

    public List<HDeControl> getAllFiles() {
        HashMap<String, HDeControl> filesMap = new HashMap<String, HDeControl>();
        Set<String> repPids = this.files.keySet();
        for (String repPid : repPids) {
            filesMap.putAll(this.files.get(repPid));
        }
        return new ArrayList<HDeControl>(filesMap.values());
    }

    public List<HDeControl> getFilesByRepPid(String repPid) {
        Map<String, HDeControl> map = this.files.get(repPid);
        return new ArrayList<HDeControl>(map.values());
    }

    public Map<String, HDeControl> getIes() {
        return this.ies;
    }

    public Map<String, HDeMetadata> getIeDnxs() {
        return this.ieDnxs;
    }

    public Map<String, HDeMetadata> getFileDnxs() {
        return this.fileDnxs;
    }

    public Map<String, Map<String, HDeControl>> getReps() {
        return this.reps;
    }

    public Map<String, Map<String, HDeControl>> getFiles() {
        return this.files;
    }

    public Map<String, HDeMetadata> getRepDnxs() {
        return this.repDnxs;
    }

    private CoreRepositoryServices getCoreRepositoryManager() {
        if (this.repositoryManager == null) {
            this.repositoryManager = (CoreRepositoryServices)ServiceLocator.getInstance().lookUp(CoreRepositoryServices.class);
        }
        return this.repositoryManager;
    }

    private CoreMetadataServices getCoreMetadataManager() {
        if (this.mdManager == null) {
            this.mdManager = (CoreMetadataServices)ServiceLocator.getInstance().lookUp(CoreMetadataServices.class);
        }
        return this.mdManager;
    }

    public Map<String, List<HDeMetadata>> getRepSources() {
        return this.repSources;
    }

    public void setRepSources(Map<String, List<HDeMetadata>> repSources) {
        this.repSources = repSources;
    }

    public Map<String, HDeMetadata> getFileDCs() {
        return this.fileDCs;
    }

    public void setFileDCs(Map<String, HDeMetadata> fileDCs) {
        this.fileDCs = fileDCs;
    }

    public Map<String, List<HDeMetadata>> getFileSources() {
        return this.fileSources;
    }

    public void setFileSources(Map<String, List<HDeMetadata>> fileSources) {
        this.fileSources = fileSources;
    }

    public Map<String, String> getMetsMDs() {
        return this.metsMDs;
    }
}

