/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.common.streams;

import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.sdk.strings.StringUtils;
import com.exlibris.digitool.common.streams.FailedToHandlerStreamException;
import com.exlibris.digitool.common.streams.StreamHandler;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;

public class Jp2ToThumStreamHandler
extends StreamHandler {
    private String maxthumbnailwidth = null;
    private String maxthumbnailheight = null;
    private String x = null;
    private String y = null;
    private static final String PARAM_SEPARATOR = "&";
    private static final String EQUALS = "=";
    private static final ExLogger logger = ExLogger.getExLogger(Jp2ToThumStreamHandler.class);

    @Override
    public void handleStream() throws FailedToHandlerStreamException {
        String fileToRead = null;
        String fileToWrite = null;
        if (this.maxthumbnailwidth == null || this.maxthumbnailwidth.trim().length() == 0) {
            this.maxthumbnailwidth = "150";
        }
        if (this.maxthumbnailheight == null || this.maxthumbnailheight.trim().length() == 0) {
            this.maxthumbnailheight = "150";
        }
        if (this.x == null || this.x.trim().length() == 0) {
            this.x = "0";
        }
        if (this.y == null || this.y.trim().length() == 0) {
            this.y = "0";
        }
        if (this.params != null && this.params.length != 0) {
            fileToRead = this.params[0];
            fileToWrite = this.params[1];
        }
        if (fileToRead == null || fileToWrite == null) {
            throw new FailedToHandlerStreamException("one of the following is missing: 'file to read', 'file to write'");
        }
        InputStream input = null;
        FileOutputStream file = null;
        try {
            int oneChar;
            GeneralParameterManager gpm = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
            String httpPort = gpm.getParameter("repository", "http_port");
            String tomcatPort = gpm.getParameter("repository", "tomcat_port");
            this.paramsPattern = StringUtils.replaceSubString(this.paramsPattern, "$http_port", httpPort);
            this.paramsPattern = StringUtils.replaceSubString(this.paramsPattern, "$tomcat_port", tomcatPort);
            this.paramsPattern = StringUtils.replaceSubString(this.paramsPattern, "$1", fileToRead);
            String paramUrl = "&maxthumbnailwidth=" + this.maxthumbnailwidth + PARAM_SEPARATOR + "maxthumbnailheight" + EQUALS + this.maxthumbnailheight + PARAM_SEPARATOR + "x" + EQUALS + this.x + PARAM_SEPARATOR + "y" + EQUALS + this.y;
            URL url = new URL(this.paramsPattern + paramUrl);
            URLConnection urlConn = url.openConnection();
            input = urlConn.getInputStream();
            while ((oneChar = input.read()) != -1) {
                if (file == null) {
                    file = new FileOutputStream(fileToWrite);
                }
                file.write(oneChar);
            }
        }
        catch (Exception e) {
            throw new FailedToHandlerStreamException("failed to create image from jp2: " + e.getMessage());
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    logger.info(DescriptorConstants.GN_UnableToCloseStream, (Object)e.getMessage());
                }
            }
            if (file != null) {
                try {
                    file.close();
                }
                catch (IOException e) {
                    logger.info(DescriptorConstants.GN_UnableToCloseStream, (Object)e.getMessage());
                }
            }
        }
    }

    public void setMaxthumbnailheight(String maxthumbnailheight) {
        this.maxthumbnailheight = maxthumbnailheight;
    }

    public void setMaxthumbnailwidth(String maxthumbnailwidth) {
        this.maxthumbnailwidth = maxthumbnailwidth;
    }

    public void setX(String x) {
        this.x = x;
    }

    public void setY(String y) {
        this.y = y;
    }
}

