/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.file;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.gov.nationalarchives.droid.container.ContainerFileIdentificationRequest;
import uk.gov.nationalarchives.droid.container.ContainerIdentifierInit;
import uk.gov.nationalarchives.droid.container.ContainerSignatureDefinitions;
import uk.gov.nationalarchives.droid.container.ContainerSignatureMatch;
import uk.gov.nationalarchives.droid.container.ContainerSignatureMatchCollection;
import uk.gov.nationalarchives.droid.container.FileFormatMapping;
import uk.gov.nationalarchives.droid.container.IdentifierEngine;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationMethod;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultCollection;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultImpl;

public class GenericContainerContentIdentifier {
    private ContainerIdentifierInit containerIdentifierInit;
    private IdentifierEngine identifierEngine;
    private Map<Integer, List<FileFormatMapping>> formats = new HashMap<Integer, List<FileFormatMapping>>();

    public IdentifierEngine getIdentifierEngine() {
        return this.identifierEngine;
    }

    public void setIdentifierEngine(IdentifierEngine identifierEngine) {
        this.identifierEngine = identifierEngine;
    }

    public void init(ContainerSignatureDefinitions defs, String containerType) {
        this.containerIdentifierInit = new ContainerIdentifierInit();
        this.containerIdentifierInit.init(defs, containerType, this.formats, null);
    }

    public ContainerIdentifierInit getContainerIdentifierInit() {
        return this.containerIdentifierInit;
    }

    public Map<Integer, List<FileFormatMapping>> getFormats() {
        return this.formats;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdentificationResultCollection process(InputStream in, IdentificationResultCollection containerResults) throws IOException {
        ContainerFileIdentificationRequest request = new ContainerFileIdentificationRequest(null);
        try {
            request.open((Object)in);
            int maxBytesToScan = -1;
            ContainerSignatureMatchCollection matches = new ContainerSignatureMatchCollection(this.getContainerIdentifierInit().getContainerSignatures(), this.getContainerIdentifierInit().getUniqueFileEntries(), (long)maxBytesToScan);
            this.getIdentifierEngine().process((IdentificationRequest)request, matches);
            HashMap<String, String> puidMap = new HashMap<String, String>();
            for (ContainerSignatureMatch match : matches.getContainerSignatureMatches()) {
                if (!match.isMatch()) continue;
                List<FileFormatMapping> mappings = this.getFormats().get(match.getSignature().getId());
                for (FileFormatMapping mapping : mappings) {
                    IdentificationResultImpl result = new IdentificationResultImpl();
                    result.setMethod(IdentificationMethod.CONTAINER);
                    result.setRequestMetaData(request.getRequestMetaData());
                    String puid = mapping.getPuid();
                    result.setPuid(mapping.getPuid());
                    if (puidMap.containsKey(puid)) continue;
                    puidMap.put(puid, "");
                    containerResults.addResult((IdentificationResult)result);
                }
            }
            request.close();
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return containerResults;
    }
}

