/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.tools.gui;

import javax.swing.JTextArea;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.PlainDocument;

public class LimitedTextArea
extends JTextArea {
    private static final long serialVersionUID = 1L;

    public LimitedTextArea(Integer limit, String initialText) {
        this(limit);
        this.setText(initialText);
    }

    public LimitedTextArea(final Integer limit) {
        this.setDocument(new PlainDocument(){
            private static final long serialVersionUID = 1L;

            @Override
            public void insertString(int offset, String str, AttributeSet attr) throws BadLocationException {
                if (str == null) {
                    return;
                }
                if (this.getLength() + str.length() <= limit) {
                    super.insertString(offset, str, attr);
                }
            }
        });
    }
}

