/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.compiler.matcher;

import java.util.ArrayList;
import java.util.List;
import net.byteseek.matcher.bytes.AllBitmaskMatcher;
import net.byteseek.matcher.bytes.AnyBitmaskMatcher;
import net.byteseek.matcher.bytes.AnyByteMatcher;
import net.byteseek.matcher.bytes.ByteMatcher;
import net.byteseek.matcher.bytes.ByteMatcherFactory;
import net.byteseek.matcher.bytes.ByteRangeMatcher;
import net.byteseek.matcher.bytes.InvertedByteMatcher;
import net.byteseek.matcher.bytes.OneByteMatcher;
import net.byteseek.matcher.bytes.TwoByteMatcher;
import net.byteseek.matcher.sequence.ByteMatcherSequenceMatcher;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.parser.ParseException;
import net.byteseek.parser.tree.ParseTree;
import net.byteseek.parser.tree.ParseTreeUtils;

public final class MatcherCompilerUtils {
    private static final boolean NOT_YET_INVERTED = false;

    private MatcherCompilerUtils() {
    }

    public static boolean isInverted(ParseTree node, boolean currentInversion) {
        return currentInversion ^ node.isValueInverted();
    }

    public static ByteMatcher createByteMatcher(ParseTree node) throws ParseException {
        return MatcherCompilerUtils.createByteMatcher(node, false);
    }

    public static ByteMatcher createByteMatcher(ParseTree node, boolean currentInversion) throws ParseException {
        return MatcherCompilerUtils.isInverted(node, currentInversion) ? new InvertedByteMatcher(node.getByteValue()) : OneByteMatcher.valueOf(node.getByteValue());
    }

    public static ByteMatcher createAnyMatcher(ParseTree node) throws ParseException {
        return MatcherCompilerUtils.createAnyMatcher(node, false);
    }

    public static ByteMatcher createAnyMatcher(ParseTree node, boolean currentInversion) throws ParseException {
        if (MatcherCompilerUtils.isInverted(node, currentInversion)) {
            throw new ParseException("Cannot invert the value of the Any matcher - matching nothing is not permitted.");
        }
        return AnyByteMatcher.ANY_BYTE_MATCHER;
    }

    public static ByteMatcher createAllBitmaskMatcher(ParseTree node) throws ParseException {
        return MatcherCompilerUtils.createAllBitmaskMatcher(node, false);
    }

    public static ByteMatcher createAllBitmaskMatcher(ParseTree node, boolean currentInversion) throws ParseException {
        return new AllBitmaskMatcher(node.getByteValue(), MatcherCompilerUtils.isInverted(node, currentInversion));
    }

    public static ByteMatcher createAnyBitmaskMatcher(ParseTree node) throws ParseException {
        return MatcherCompilerUtils.createAnyBitmaskMatcher(node, false);
    }

    public static ByteMatcher createAnyBitmaskMatcher(ParseTree node, boolean currentInversion) throws ParseException {
        return new AnyBitmaskMatcher(node.getByteValue(), MatcherCompilerUtils.isInverted(node, currentInversion));
    }

    public static ByteMatcher createRangeMatcher(ParseTree node) throws ParseException {
        return MatcherCompilerUtils.createRangeMatcher(node, false);
    }

    public static ByteMatcher createRangeMatcher(ParseTree node, boolean currentInversion) throws ParseException {
        return new ByteRangeMatcher(ParseTreeUtils.getFirstRangeValue(node), ParseTreeUtils.getSecondRangeValue(node), MatcherCompilerUtils.isInverted(node, currentInversion));
    }

    public static ByteMatcher createMatcherFromSet(ParseTree node, ByteMatcherFactory matcherFactory) throws ParseException {
        return MatcherCompilerUtils.createMatcherFromSet(node, false, matcherFactory);
    }

    public static ByteMatcher createMatcherFromSet(ParseTree node, boolean currentInversion, ByteMatcherFactory matcherFactory) throws ParseException {
        boolean isInverted = MatcherCompilerUtils.isInverted(node, currentInversion);
        if (node.getNumChildren() == 1) {
            ParseTree singleElement = node.getChild(0);
            switch (singleElement.getParseTreeType()) {
                case BYTE: {
                    return MatcherCompilerUtils.createByteMatcher(singleElement, isInverted);
                }
                case ANY: {
                    return MatcherCompilerUtils.createAnyMatcher(singleElement, isInverted);
                }
                case ALL_BITMASK: {
                    return MatcherCompilerUtils.createAllBitmaskMatcher(singleElement, isInverted);
                }
                case ANY_BITMASK: {
                    return MatcherCompilerUtils.createAnyBitmaskMatcher(singleElement, isInverted);
                }
                case RANGE: {
                    return MatcherCompilerUtils.createRangeMatcher(singleElement, isInverted);
                }
                case SET: {
                    return MatcherCompilerUtils.createMatcherFromSet(singleElement, isInverted, matcherFactory);
                }
            }
        }
        return matcherFactory.create(ParseTreeUtils.getSetValues(node), isInverted);
    }

    public static SequenceMatcher createCaseInsensitiveMatcher(String string) {
        return new ByteMatcherSequenceMatcher(MatcherCompilerUtils.buildCaseInsensitiveMatcherList(string));
    }

    private static List<ByteMatcher> buildCaseInsensitiveMatcherList(String string) {
        ArrayList<ByteMatcher> sequence = new ArrayList<ByteMatcher>(string.length());
        for (int pos = 0; pos < string.length(); ++pos) {
            ByteMatcher matcher = MatcherCompilerUtils.createCaseInsensitiveMatcher(string.charAt(pos));
            sequence.add(matcher);
        }
        return sequence;
    }

    public static ByteMatcher createCaseInsensitiveMatcher(char caseChar) {
        byte firstByte = (byte)(caseChar & 0xFF);
        if (caseChar >= 'a' && caseChar <= 'z') {
            byte secondByte = (byte)(firstByte - 32);
            return new TwoByteMatcher(firstByte, secondByte);
        }
        if (caseChar >= 'A' && caseChar <= 'Z') {
            byte secondByte = (byte)(firstByte + 32);
            return new TwoByteMatcher(firstByte, secondByte);
        }
        return OneByteMatcher.valueOf(firstByte);
    }
}

