/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.matcher.bytes;

import java.util.Iterator;
import java.util.NoSuchElementException;
import net.byteseek.matcher.bytes.ByteMatcher;
import net.byteseek.matcher.sequence.ByteMatcherSequenceMatcher;
import net.byteseek.matcher.sequence.SequenceMatcher;
import net.byteseek.utils.ArgUtils;

public abstract class AbstractByteMatcher
implements ByteMatcher {
    @Override
    public final ByteMatcher getMatcherForPosition(int position) {
        if (position != 0) {
            throw new IndexOutOfBoundsException("ByteMatchers only have a matcher at position 0.");
        }
        return this;
    }

    @Override
    public final int length() {
        return 1;
    }

    @Override
    public final SequenceMatcher reverse() {
        return this;
    }

    @Override
    public final SequenceMatcher subsequence(int beginIndex, int endIndex) {
        if (beginIndex != 0 || endIndex != 1) {
            throw new IndexOutOfBoundsException("ByteMatchers only support a sequence starting at zero with a length of one.");
        }
        return this;
    }

    @Override
    public final SequenceMatcher subsequence(int beginIndex) {
        if (beginIndex != 0) {
            throw new IndexOutOfBoundsException("ByteMatchers only support a sequence starting at zero with a length of one.");
        }
        return this;
    }

    @Override
    public SequenceMatcher repeat(int numberOfRepeats) {
        ArgUtils.checkPositiveInteger(numberOfRepeats, "numberOfRepeats");
        if (numberOfRepeats == 1) {
            return this;
        }
        return new ByteMatcherSequenceMatcher(numberOfRepeats, (ByteMatcher)this);
    }

    @Override
    public Iterator<ByteMatcher> iterator() {
        return new ByteMatcherIterator();
    }

    public class ByteMatcherIterator
    implements Iterator<ByteMatcher> {
        private boolean iterated = false;

        @Override
        public boolean hasNext() {
            return !this.iterated;
        }

        @Override
        public ByteMatcher next() {
            if (this.hasNext()) {
                this.iterated = true;
                return AbstractByteMatcher.this;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Byte matcher iterators cannot remove the ByteMatcher");
        }
    }
}

