/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.utils.collections;

import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.byteseek.utils.ArgUtils;

public class ImmutableListIterator<T>
implements Iterator<T> {
    private final List<T> list;
    private int index;

    public ImmutableListIterator(List<T> list) {
        ArgUtils.checkNullCollection(list);
        this.list = list;
    }

    @Override
    public boolean hasNext() {
        return this.index < this.list.size();
    }

    @Override
    public T next() {
        if (this.hasNext()) {
            return this.list.get(this.index++);
        }
        throw new NoSuchElementException(String.format("Index position %d is greater than or equal to the list size %d", this.index, this.list.size()));
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("Removal not supported by the ImmutableListIterator.");
    }
}

