/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.pcx;

import com.sun.jimi.core.decoder.pcx.PCXHeader;
import com.sun.jimi.core.util.LEDataInputStream;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;

public class PCXColorMap {
    private byte[] red;
    private byte[] green;
    private byte[] blue;
    private ColorModel colorModel;

    public PCXColorMap(LEDataInputStream lEDataInputStream, int n, byte by) {
        block5: {
            if (by != PCXHeader.V3_0p) break block5;
            try {
                lEDataInputStream.mark(n);
                lEDataInputStream.skip(n - 16 - 769);
                byte by2 = lEDataInputStream.readByte();
                if (by2 == 12) {
                    this.red = new byte[256];
                    this.green = new byte[256];
                    this.blue = new byte[256];
                    int n2 = 0;
                    while (n2 < 256) {
                        this.red[n2] = lEDataInputStream.readByte();
                        this.green[n2] = lEDataInputStream.readByte();
                        this.blue[n2] = lEDataInputStream.readByte();
                        ++n2;
                    }
                    this.colorModel = new IndexColorModel(8, 256, this.red, this.green, this.blue);
                    lEDataInputStream.reset();
                    lEDataInputStream.skip(48L);
                    break block5;
                }
                lEDataInputStream.reset();
                this.red = new byte[16];
                this.green = new byte[16];
                this.blue = new byte[16];
                int n3 = 0;
                while (n3 < 16) {
                    this.red[n3] = lEDataInputStream.readByte();
                    this.green[n3] = lEDataInputStream.readByte();
                    this.blue[n3] = lEDataInputStream.readByte();
                    ++n3;
                }
                this.colorModel = new IndexColorModel(4, 16, this.red, this.green, this.blue);
            }
            catch (Exception exception) {}
        }
    }

    public ColorModel getColorModel() {
        return this.colorModel;
    }
}

