/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.decoder.psd;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.compat.JimiDecoderBase;
import com.sun.jimi.core.decoder.psd.PSDColorMode;
import com.sun.jimi.core.decoder.psd.PSDFileHeader;
import com.sun.jimi.core.decoder.psd.PSDImageResources;
import com.sun.jimi.core.decoder.psd.PSDLayersMasks;
import com.sun.jimi.core.util.JimiUtil;
import com.sun.jimi.core.util.Packbits;
import java.awt.image.DirectColorModel;
import java.awt.image.IndexColorModel;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;

public class PSDDecoder
extends JimiDecoderBase {
    private AdaptiveRasterImage ji;
    private InputStream in;
    private DataInputStream dIn;
    private int state;
    PSDFileHeader psdFH;
    PSDColorMode psdCM;
    PSDLayersMasks psdLM;
    PSDImageResources psdIR;
    short compression;
    short maxSLLen_;
    short[] scanlineLengths_;

    private void decodeCompressedBitmapChannel() throws JimiException, IOException {
        byte[] byArray = new byte[this.maxSLLen_];
        byte[] byArray2 = new byte[this.psdFH.columns / 8 + (this.psdFH.columns % 8 != 0 ? 1 : 0)];
        byte[] byArray3 = new byte[this.psdFH.columns];
        int n = 0;
        while (n < this.psdFH.rows) {
            this.dIn.readFully(byArray, 0, this.scanlineLengths_[n]);
            Packbits.unpackbits(byArray, byArray2);
            int n2 = byArray2.length;
            while (--n2 >= 0) {
                byArray2[n2] = ~byArray2[n2];
            }
            JimiUtil.expandPixels(1, byArray2, byArray3, byArray3.length);
            this.ji.setChannel(0, n, byArray3);
            this.setProgress(n * 100 / this.psdFH.rows);
            ++n;
        }
    }

    private void decodeCompressedChannel() throws JimiException, IOException {
        byte[] byArray = new byte[this.psdFH.columns];
        byte[] byArray2 = new byte[this.maxSLLen_];
        int n = 0;
        while (n < this.psdFH.rows) {
            this.dIn.readFully(byArray2, 0, this.scanlineLengths_[n]);
            Packbits.unpackbits(byArray2, byArray);
            this.ji.setChannel(0, n, byArray);
            this.setProgress(n * 100 / this.psdFH.rows);
            ++n;
        }
    }

    private void decodeCompressedRGB() throws JimiException, IOException {
        byte[] byArray = new byte[this.psdFH.columns];
        byte[] byArray2 = new byte[this.maxSLLen_];
        int n = this.psdFH.rows * 3;
        int n2 = this.psdFH.rows;
        int n3 = 0;
        while (n3 < this.psdFH.rows) {
            this.dIn.readFully(byArray2, 0, this.scanlineLengths_[n3]);
            Packbits.unpackbits(byArray2, byArray);
            this.ji.setChannel(16, n3, byArray);
            this.setProgress(n3 * 100 / n);
            ++n3;
        }
        n3 = 0;
        while (n3 < this.psdFH.rows) {
            this.dIn.readFully(byArray2, 0, this.scanlineLengths_[n3 + this.psdFH.rows]);
            Packbits.unpackbits(byArray2, byArray);
            this.ji.setChannel(8, n3, byArray);
            this.setProgress((n2 + n3) * 100 / n);
            ++n3;
        }
        n3 = 0;
        while (n3 < this.psdFH.rows) {
            this.dIn.readFully(byArray2, 0, this.scanlineLengths_[n3 + 2 * this.psdFH.rows]);
            Packbits.unpackbits(byArray2, byArray);
            this.ji.setChannel(0, n3, byArray);
            this.setProgress((n2 * 2 + n3) * 100 / n);
            ++n3;
        }
        if (this.psdFH.channels >= 4) {
            n3 = 0;
            while (n3 < this.psdFH.rows) {
                this.dIn.readFully(byArray2, 0, this.scanlineLengths_[n3 + 3 * this.psdFH.rows]);
                Packbits.unpackbits(byArray2, byArray);
                this.ji.setChannel(24, n3, byArray);
                this.setProgress((n2 * 3 + n3) * 100 / n);
                ++n3;
            }
        }
    }

    void decodeImage() throws JimiException, IOException {
        this.compression = this.dIn.readShort();
        if (this.compression != 1 && this.compression != 0) {
            throw new JimiException("PSDDecoder invalid compression code " + this.compression);
        }
        switch (this.psdFH.mode) {
            case 3: {
                if (this.compression == 0) {
                    this.decodeRawRGB();
                    break;
                }
                this.decodeSLLData();
                this.decodeCompressedRGB();
                break;
            }
            case 2: {
                if (this.compression == 0) {
                    this.decodeRawChannel();
                    break;
                }
                this.decodeSLLData();
                this.decodeCompressedChannel();
                break;
            }
            case 1: {
                if (this.compression == 0) {
                    this.decodeRawChannel();
                    break;
                }
                this.decodeSLLData();
                this.decodeCompressedChannel();
                break;
            }
            case 0: {
                if (this.compression == 0) {
                    this.decodeRawBitmapChannel();
                    break;
                }
                this.decodeSLLData();
                this.decodeCompressedBitmapChannel();
                break;
            }
        }
    }

    private void decodeRawBitmapChannel() throws JimiException, IOException {
        byte[] byArray = new byte[this.psdFH.columns / 8 + (this.psdFH.columns % 8 != 0 ? 1 : 0)];
        byte[] byArray2 = new byte[this.psdFH.columns];
        int n = 0;
        while (n < this.psdFH.rows) {
            this.dIn.readFully(byArray);
            int n2 = byArray.length;
            while (--n2 >= 0) {
                byArray[n2] = ~byArray[n2];
            }
            JimiUtil.expandPixels(1, byArray, byArray2, byArray2.length);
            this.ji.setChannel(0, n, byArray2);
            this.setProgress(n * 100 / this.psdFH.rows);
            ++n;
        }
    }

    private void decodeRawChannel() throws JimiException, IOException {
        byte[] byArray = new byte[this.psdFH.columns];
        int n = 0;
        while (n < this.psdFH.rows) {
            this.dIn.readFully(byArray);
            this.ji.setChannel(0, n, byArray);
            this.setProgress(n * 100 / this.psdFH.rows);
            ++n;
        }
    }

    private void decodeRawRGB() throws JimiException, IOException {
        byte[] byArray = new byte[this.psdFH.columns];
        int n = this.psdFH.rows * Math.min(4, this.psdFH.channels);
        int n2 = this.psdFH.rows;
        int n3 = 0;
        while (n3 < this.psdFH.rows) {
            this.dIn.readFully(byArray);
            this.ji.setChannel(16, n3, byArray);
            this.setProgress(n3 * 100 / n);
            ++n3;
        }
        n3 = 0;
        while (n3 < this.psdFH.rows) {
            this.dIn.readFully(byArray);
            this.ji.setChannel(8, n3, byArray);
            this.setProgress((n2 + n3) * 100 / n);
            ++n3;
        }
        n3 = 0;
        while (n3 < this.psdFH.rows) {
            this.dIn.readFully(byArray);
            this.ji.setChannel(0, n3, byArray);
            this.setProgress((n2 * 2 + n3) * 100 / n);
            ++n3;
        }
        if (this.psdFH.channels >= 4) {
            n3 = 0;
            while (n3 < this.psdFH.rows) {
                this.dIn.readFully(byArray);
                this.ji.setChannel(24, n3, byArray);
                this.setProgress((n2 * 3 + n3) * 100 / n);
                ++n3;
            }
        }
    }

    private void decodeSLLData() throws IOException {
        this.scanlineLengths_ = new short[this.psdFH.rows * this.psdFH.channels];
        this.maxSLLen_ = (short)-1;
        int n = 0;
        while (n < this.psdFH.rows * this.psdFH.channels) {
            short s;
            this.scanlineLengths_[n] = s = this.dIn.readShort();
            this.maxSLLen_ = s > this.maxSLLen_ ? s : this.maxSLLen_;
            ++n;
        }
    }

    public boolean driveDecoder() throws JimiException {
        try {
            this.psdFH = new PSDFileHeader(this.dIn);
            this.psdCM = new PSDColorMode(this.dIn, this.psdFH);
            this.initJimiImage();
            this.state |= 2;
            this.psdIR = new PSDImageResources(this.dIn);
            this.psdLM = new PSDLayersMasks(this.dIn);
            this.decodeImage();
            this.ji.addFullCoverage();
            this.state |= 4;
        }
        catch (IOException iOException) {
            throw new JimiException(iOException.getMessage());
        }
        return false;
    }

    public void freeDecoder() throws JimiException {
        this.in = null;
        this.ji = null;
    }

    public AdaptiveRasterImage getJimiImage() {
        return this.ji;
    }

    public int getState() {
        return this.state;
    }

    public void initDecoder(InputStream inputStream, AdaptiveRasterImage adaptiveRasterImage) throws JimiException {
        this.in = inputStream;
        this.dIn = new DataInputStream(new BufferedInputStream(inputStream));
        this.ji = adaptiveRasterImage;
        this.state = 0;
    }

    private void initJimiImage() throws JimiException {
        if (this.psdFH.signature != 943870035 || this.psdFH.version != 1) {
            throw new JimiException("PSDDecoder invalid PSD file format");
        }
        if (this.psdFH.mode == 0 && this.psdFH.depth != 1 || this.psdFH.mode != 0 && this.psdFH.depth != 8) {
            throw new JimiException("Unsupported depth for mode file format. mode = " + this.psdFH.mode + " depth = " + this.psdFH.depth);
        }
        this.ji.setSize(this.psdFH.columns, this.psdFH.rows);
        switch (this.psdFH.mode) {
            case 3: {
                this.ji.setColorModel(new DirectColorModel(24, 0xFF0000, 65280, 255));
                this.ji.setPixels();
                this.ji.setChannel(-1048576L);
                break;
            }
            case 2: {
                if (this.psdFH.channels != 1) {
                    throw new JimiException("PSDDecoder INDEXED mode files must have 1 channel");
                }
                if (this.psdCM.length == 0) {
                    throw new JimiException("PSDDecoder INDEXED mode files require a color mode section");
                }
                this.ji.setColorModel(new IndexColorModel(8, this.psdCM.cmap.length / 3, this.psdCM.cmap, 0, false));
                this.ji.setPixels();
                break;
            }
            case 1: {
                if (this.psdFH.channels != 1) {
                    throw new JimiException("PSDDecoder GRAYSCALE mode files must have 1 channel");
                }
                this.ji.setColorModel(new DirectColorModel(8, 255, 255, 255));
                this.ji.setPixels();
                break;
            }
            case 0: {
                if (this.psdFH.channels != 1 || this.psdFH.depth != 1) {
                    throw new JimiException("PSDDecoder BITMAP must be 1 channel and 1 bit depth");
                }
                this.ji.setColorModel(new DirectColorModel(1, 1, 1, 1));
                this.ji.setPixels();
                break;
            }
            default: {
                throw new JimiException("PSDDecoder unsupported image mode format " + this.psdFH.mode);
            }
        }
    }

    public boolean usesChanneledData() {
        return true;
    }
}

