/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.archive;

import de.schlichtherle.truezip.rof.AbstractReadOnlyFile;
import java.io.IOException;
import net.byteseek.io.reader.WindowReader;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveFileUtils;

public final class TrueZipReader
extends AbstractReadOnlyFile {
    private final WindowReader reader;
    private long filePointer;
    private boolean closeReaderIfClosed;
    private boolean closed;

    public TrueZipReader(WindowReader reader) {
        this(reader, false);
    }

    public TrueZipReader(WindowReader reader, boolean closeReaderIfClosed) {
        this.reader = reader;
        this.closeReaderIfClosed = closeReaderIfClosed;
    }

    public long length() throws IOException {
        return this.reader.length();
    }

    public long getFilePointer() throws IOException {
        this.ensureOpen();
        return this.filePointer;
    }

    public int read() throws IOException {
        this.ensureOpen();
        int result = this.reader.readByte(this.filePointer);
        if (result >= 0) {
            ++this.filePointer;
        }
        return result;
    }

    public void seek(long position) throws IOException {
        this.ensureOpen();
        if (position < 0L) {
            throw new IOException("Cannot seek to a negative position: " + position);
        }
        if (position >= this.reader.length()) {
            throw new IOException("Cannot seek past the end of data with length " + this.reader.length() + ".  Seek position was " + position);
        }
        this.filePointer = position;
    }

    public int read(byte[] bytes, int offset, int length) throws IOException {
        this.ensureOpen();
        if ((offset | length) < 0) {
            throw new IndexOutOfBoundsException("Offset or length cannot be negative: {" + offset + "," + length + "}");
        }
        if (this.filePointer >= this.length() || length == 0) {
            return -1;
        }
        int bytesCopied = ArchiveFileUtils.copyToBuffer(this.reader, this.filePointer, bytes, offset, length);
        this.filePointer += (long)bytesCopied;
        return bytesCopied;
    }

    public void close() throws IOException {
        if (!this.closed && this.closeReaderIfClosed) {
            this.reader.close();
        }
        this.closed = true;
    }

    private void ensureOpen() throws IOException {
        if (this.closed) {
            throw new IOException("The " + (Object)((Object)this) + " is closed.");
        }
    }
}

