/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.gzip;

import java.util.HashMap;
import java.util.Map;

public final class OperatingSystem {
    private static Map<Integer, OperatingSystem> values = new HashMap<Integer, OperatingSystem>();
    public static final OperatingSystem FAT_FILESYSTEM = new OperatingSystem(0, "FAT filesystem (MS-DOS, OS/2, NT/Win32)", true);
    public static final OperatingSystem AMIGA = new OperatingSystem(1, "Amiga", true);
    public static final OperatingSystem VMS = new OperatingSystem(2, "VMS (or OpenVMS)", true);
    public static final OperatingSystem UNIX = new OperatingSystem(3, "Unix", true);
    public static final OperatingSystem VM_CMS = new OperatingSystem(4, "VM/CMS", true);
    public static final OperatingSystem ATARI_TOS = new OperatingSystem(5, "Atari TOS", true);
    public static final OperatingSystem HPFS = new OperatingSystem(6, "HPFS filesystem (OS/2, NT)", true);
    public static final OperatingSystem MACINTOSH = new OperatingSystem(7, "Macintosh)", true);
    public static final OperatingSystem Z_SYSTEM = new OperatingSystem(8, "Z-System", true);
    public static final OperatingSystem CP_M = new OperatingSystem(9, "CP/M", true);
    public static final OperatingSystem TOPS_20 = new OperatingSystem(10, "TOPS-20", true);
    public static final OperatingSystem NTFS = new OperatingSystem(11, "NTFS filesystem (NT)", true);
    public static final OperatingSystem QDOS = new OperatingSystem(12, "QDOS", true);
    public static final OperatingSystem ACORN_RISCOS = new OperatingSystem(13, "Acorn RISCOS", true);
    public static final OperatingSystem UNKNOWN = new OperatingSystem(255, "Unknown", true);
    public final int value;
    public final String label;
    public final boolean valid;

    protected OperatingSystem(int value, String label, boolean valid) {
        this.value = value;
        this.label = label;
        this.valid = valid;
    }

    public static OperatingSystem fromValue(int n) {
        OperatingSystem v = values.get(n);
        if (v == null) {
            v = new OperatingSystem(n, null, false);
        }
        return v;
    }

    static {
        values.put(OperatingSystem.FAT_FILESYSTEM.value, FAT_FILESYSTEM);
        values.put(OperatingSystem.AMIGA.value, AMIGA);
        values.put(OperatingSystem.VMS.value, VMS);
        values.put(OperatingSystem.UNIX.value, UNIX);
        values.put(OperatingSystem.VM_CMS.value, VM_CMS);
        values.put(OperatingSystem.ATARI_TOS.value, ATARI_TOS);
        values.put(OperatingSystem.HPFS.value, HPFS);
        values.put(OperatingSystem.MACINTOSH.value, MACINTOSH);
        values.put(OperatingSystem.Z_SYSTEM.value, Z_SYSTEM);
        values.put(OperatingSystem.CP_M.value, CP_M);
        values.put(OperatingSystem.TOPS_20.value, TOPS_20);
        values.put(OperatingSystem.NTFS.value, NTFS);
        values.put(OperatingSystem.QDOS.value, QDOS);
        values.put(OperatingSystem.ACORN_RISCOS.value, ACORN_RISCOS);
        values.put(OperatingSystem.UNKNOWN.value, UNKNOWN);
    }
}

