/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.tiff;

import edu.harvard.hul.ois.jhove.NisoImageMetadata;
import edu.harvard.hul.ois.jhove.module.tiff.IFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffIFD;
import edu.harvard.hul.ois.jhove.module.tiff.TiffProfile;

public final class TiffProfileClassG
extends TiffProfile {
    public TiffProfileClassG() {
        this._profileText = "Baseline grayscale (Class G)";
    }

    @Override
    public boolean satisfiesThisProfile(IFD ifd) {
        if (!(ifd instanceof TiffIFD)) {
            return false;
        }
        TiffIFD tifd = (TiffIFD)ifd;
        NisoImageMetadata niso = tifd.getNisoImageMetadata();
        if (niso.getImageWidth() == -1L || niso.getImageLength() == -1L || niso.getStripOffsets() == null || niso.getRowsPerStrip() == -1L || niso.getStripByteCounts() == null || niso.getXSamplingFrequency() == null || niso.getYSamplingFrequency() == null) {
            return false;
        }
        if (niso.getSamplesPerPixel() > 1) {
            return false;
        }
        int[] bps = niso.getBitsPerSample();
        if (bps == null || bps[0] != 4 && bps[0] != 8) {
            return false;
        }
        if (!this.satisfiesCompression(tifd, new int[]{1, 32773})) {
            return false;
        }
        if (!this.satisfiesPhotometricInterpretation(tifd, new int[]{0, 1})) {
            return false;
        }
        return this.satisfiesResolutionUnit(tifd, new int[]{1, 2, 3});
    }
}

