/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.sipView.actions;

import ch.docuteam.darc.exceptions.DocumentIsReadOnlyException;
import ch.docuteam.darc.exceptions.FileOrFolderIsInUseException;
import ch.docuteam.darc.exceptions.OriginalSIPIsMissingException;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.mapping.csv.CsvImportWarning;
import ch.docuteam.mapping.csv.CsvToMetsImporter;
import ch.docuteam.mapping.csv.ImportResult;
import ch.docuteam.packer.gui.PackerConstants;
import ch.docuteam.packer.gui.sipView.SIPView;
import ch.docuteam.packer.gui.sipView.actions.AbstractSIPViewAction;
import ch.docuteam.tools.file.ConfigurationFileLoader;
import ch.docuteam.tools.file.FileFilter;
import ch.docuteam.tools.file.exception.FileUtilExceptionListException;
import ch.docuteam.tools.translations.I18N;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.List;
import java.util.function.BooleanSupplier;
import java.util.stream.Collectors;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;

public class ImportMetadataFromCSVAction
extends AbstractSIPViewAction {
    public static final String CHOOSER_NAME = "CHOOSE_CSV";
    protected String lastUsedFileChooserFolder;
    private final Path configLocation;
    private final boolean isContextAction;

    public ImportMetadataFromCSVAction(SIPView sipView, boolean isContextAction) {
        super(I18N.translate((String)"ButtonImportCSVFile"), PackerConstants.getImageIcon("ImportCSV.png"), sipView);
        this.isContextAction = isContextAction;
        this.putValue("ShortDescription", I18N.translate((String)"ToolTipImportCSV"));
        this.putValue("actionHideKey", "importMetadataFromCSVAction");
        this.setEnabled(false);
        this.configLocation = new ConfigurationFileLoader(sipView.getLauncherView().getConfigDirectory()).load("csv-mapping.xml").toPath();
        this.lastUsedFileChooserFolder = sipView.getLauncherView().getDataDirectory();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Path pathToCsv = this.getPathToCsv();
        if (pathToCsv == null) {
            return;
        }
        ImportResult importResult = CsvToMetsImporter.importCsv((Document)this.sipView.getDocument(), (Path)pathToCsv, (Path)this.configLocation, (BooleanSupplier)this.getSaveHandler());
        if (importResult.isSuccess()) {
            JOptionPane.showMessageDialog(this.sipView, this.getSuccessMessagesWithPotentialWarnings(importResult.getWarnings()), I18N.translate((String)"TitleImportCsvSuccess"), 1);
        } else {
            JOptionPane.showMessageDialog(this.sipView, I18N.translate((String)importResult.getError().getMessageKey(), (Object[])importResult.getAdditionalErrorObjects()), I18N.translate((String)"TitleImportCsvFailure"), 0);
        }
        this.sipView.updateTree();
    }

    private BooleanSupplier getSaveHandler() {
        return () -> {
            int selectedOption = JOptionPane.showConfirmDialog(this.sipView, I18N.translate((String)"ImportCsvManualSaveMessage"), I18N.translate((String)"ImportCsvManualSaveTitle"), 0, 3);
            if (selectedOption == 0) {
                try {
                    this.sipView.getDocument().save(false, true);
                    return true;
                }
                catch (DocumentIsReadOnlyException | FileOrFolderIsInUseException | OriginalSIPIsMissingException | FileUtilExceptionListException | IOException ex) {
                    return false;
                }
            }
            return false;
        };
    }

    private String getSuccessMessagesWithPotentialWarnings(List<CsvImportWarning> warnings) {
        String successMessage = I18N.translate((String)"ImportCsvSuccess");
        if (warnings.isEmpty()) {
            return successMessage;
        }
        String formattedWarnings = warnings.stream().map(warning -> I18N.translate((String)warning.getWarningType().getMessageKey(), (Object[])new Object[]{warning.getNode(), warning.getProperty(), warning.getValue()})).collect(Collectors.joining(System.lineSeparator()));
        String warningsHeader = I18N.translate((String)"ImportCsvWarningHeader");
        return String.join((CharSequence)System.lineSeparator(), successMessage, warningsHeader, formattedWarnings);
    }

    private Path getPathToCsv() {
        if (this.isContextAction) {
            return this.getContextFile();
        }
        return this.getFileChooserFile();
    }

    private Path getFileChooserFile() {
        JFileChooser fileChooser = new JFileChooser(this.lastUsedFileChooserFolder);
        fileChooser.setFileSelectionMode(0);
        fileChooser.setFileFilter((javax.swing.filechooser.FileFilter)FileFilter.CSV_OR_DIRECTORY);
        fileChooser.setMultiSelectionEnabled(false);
        fileChooser.setName(CHOOSER_NAME);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setDialogTitle(I18N.translate((String)"TitleImportCSVChooser"));
        int result = fileChooser.showOpenDialog(this.sipView);
        if (result == 1 || result == -1) {
            return null;
        }
        this.lastUsedFileChooserFolder = fileChooser.getSelectedFile().getParent();
        return fileChooser.getSelectedFile().toPath();
    }

    private Path getContextFile() {
        return this.sipView.getSelectedNode().getFile().toPath();
    }

    @Override
    public void enableOrDisable() {
        boolean enabled = this.sipView.getDocument().canWrite() && Files.isReadable(this.configLocation) && (!this.isContextAction || this.isCsvNode());
        this.setEnabled(enabled);
    }

    private boolean isCsvNode() {
        return this.sipView.getTreeTable().getSelectedRowCount() == 1 && this.sipView.getSelectedNode().isFile() && this.sipView.getSelectedNode().fileExists() && this.sipView.getSelectedNode().getLabel().endsWith(".csv");
    }
}

