/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mdconfig;

import ch.docuteam.darc.exceptions.MetadataElementValidatorException;
import ch.docuteam.darc.mdconfig.MetadataElement;
import ch.docuteam.darc.mdconfig.MetadataElementValidator;
import ch.docuteam.darc.mdconfig.MetadataElementValidatorDateRangeCH;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFolder;
import ch.docuteam.tools.translations.I18N;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class MetadataElementValidatorDateHierarchyRangeCH
implements MetadataElementValidator {
    @Override
    public void check(String value, NodeAbstract context, MetadataElement metadataElement) throws MetadataElementValidatorException {
        if (value == null || value.isEmpty()) {
            return;
        }
        if (value.equals(I18N.translate_NoCheck((String)"NoDate"))) {
            return;
        }
        new MetadataElementValidatorDateRangeCH().check(value, context, metadataElement);
        String[] nodeValues = value.split(" *- *");
        Calendar[] values = this.getValueRange(nodeValues);
        Calendar[] limits = null;
        try {
            limits = this.getChildrenValues(context, metadataElement);
        }
        catch (MetadataElementValidatorException e) {
            throw new MetadataElementValidatorException(e.getLocalizedMessage());
        }
        if (limits != null && (limits[0] != null || limits[1] != null) && (limits[0] != null && values[0].after(limits[0]) || limits[1] != null && values[1].before(limits[1]))) {
            throw new MetadataElementValidatorException(I18N.translate_NoCheck((String)"MessageValidatorDateHierarchyRangeCHNotValid", (Object[])new Object[]{value}));
        }
        if (!context.isRoot().booleanValue()) {
            String[] parentValues = null;
            try {
                parentValues = this.getParentValues(context, metadataElement);
                if (parentValues == null || parentValues.length == 0) {
                    return;
                }
            }
            catch (Exception e) {
                throw new MetadataElementValidatorException(e.getLocalizedMessage());
            }
            limits = this.getValueRange(parentValues);
            if (values[0].before(limits[0]) || values[1].after(limits[1])) {
                throw new MetadataElementValidatorException(I18N.translate_NoCheck((String)"MessageValidatorDateHierarchyRangeCHNotValid", (Object[])new Object[]{value}));
            }
        }
    }

    private Calendar[] getValueRange(String[] dateRange) throws MetadataElementValidatorException {
        Calendar[] range = new Calendar[2];
        switch (dateRange.length) {
            case 1: {
                range[0] = this.getLowerValue(dateRange[0]);
                range[1] = this.getUpperValue(dateRange[0]);
                break;
            }
            case 2: {
                range[0] = this.getLowerValue(dateRange[0]);
                range[1] = this.getUpperValue(dateRange[1]);
                break;
            }
            default: {
                throw new MetadataElementValidatorException(I18N.translate_NoCheck((String)"MessageValidatorDateHierarchyRangeCHInvalidNumberOfValues", (Object[])new Object[]{dateRange.length}));
            }
        }
        return range;
    }

    private Calendar[] getChildrenValues(NodeAbstract context, MetadataElement metadataElement) throws MetadataElementValidatorException {
        if (!context.isFolder()) {
            return null;
        }
        Calendar[] limits = new Calendar[2];
        for (NodeAbstract child : ((NodeFolder)context).getDescendants()) {
            String[] values;
            String value = null;
            try {
                value = child.getDynamicMetadataValueForName(metadataElement.getAccessorName());
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (value == null || value.isEmpty() || (values = value.split(" *- *")).length == 0) continue;
            Calendar lowerLimit = this.getLowerValue(values[0]);
            if (limits[0] == null || limits[0].after(lowerLimit)) {
                limits[0] = lowerLimit;
            }
            Calendar upperLimit = this.getUpperValue(values.length > 1 ? values[1] : values[0]);
            if (limits[1] != null && !limits[1].before(upperLimit)) continue;
            limits[1] = upperLimit;
        }
        return limits;
    }

    private String[] getParentValues(NodeAbstract context, MetadataElement metadataElement) throws Exception {
        NodeFolder parent = (NodeFolder)context.getParent();
        String value = parent.getDynamicMetadataValueForName(metadataElement.getAccessorName());
        if (value == null || value.isEmpty()) {
            if (parent.isRoot().booleanValue()) {
                return null;
            }
            return this.getParentValues(parent, metadataElement);
        }
        if (value.equals(I18N.translate_NoCheck((String)"NoDate"))) {
            return null;
        }
        return value.split(" *- *");
    }

    private Calendar getLowerValue(String value) throws MetadataElementValidatorException {
        Calendar lowerValue = Calendar.getInstance();
        try {
            Date date = this.getDateFormat(value).parse(value);
            lowerValue.setTime(date);
            switch (value.length()) {
                case 4: {
                    lowerValue.set(2, lowerValue.getMinimum(2));
                    lowerValue.set(5, lowerValue.getMinimum(5));
                    break;
                }
                case 7: {
                    lowerValue.set(5, lowerValue.getMinimum(5));
                }
            }
        }
        catch (ParseException e) {
            throw new MetadataElementValidatorException(I18N.translate_NoCheck((String)"MessageValidatorDateCHCantConvert", (Object[])new Object[]{value}));
        }
        return lowerValue;
    }

    private Calendar getUpperValue(String value) throws MetadataElementValidatorException {
        Calendar upperValue = Calendar.getInstance();
        try {
            Date date = this.getDateFormat(value).parse(value);
            upperValue.setTime(date);
            switch (value.length()) {
                case 4: {
                    upperValue.set(2, upperValue.getMaximum(2));
                    upperValue.set(5, upperValue.getMaximum(5));
                    break;
                }
                case 7: {
                    upperValue.set(5, upperValue.getMaximum(5));
                }
            }
        }
        catch (ParseException e) {
            throw new MetadataElementValidatorException(I18N.translate_NoCheck((String)"MessageValidatorDateCHCantConvert", (Object[])new Object[]{value}));
        }
        return upperValue;
    }

    private DateFormat getDateFormat(String date) throws MetadataElementValidatorException {
        SimpleDateFormat df;
        switch (date.length()) {
            case 4: {
                df = new SimpleDateFormat("yyyy");
                break;
            }
            case 6: 
            case 7: {
                df = new SimpleDateFormat("M.yyyy");
                break;
            }
            case 8: 
            case 9: 
            case 10: {
                df = new SimpleDateFormat("d.M.yyyy");
                break;
            }
            default: {
                throw new MetadataElementValidatorException(I18N.translate_NoCheck((String)"MessageValidatorDateCHCantConvert", (Object[])new Object[]{date}));
            }
        }
        df.setLenient(false);
        return df;
    }
}

