/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.services;

import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.fsutils.InfraFSUtil;
import com.exlibris.core.infra.common.shared.dataObjects.KeyValuePair;
import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.common.DateHandler;
import com.exlibris.core.infra.svc.api.common.ExternalResourceExplorer;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.queue.QueueConstants;
import com.exlibris.core.infra.svc.api.queue.WorkQueue;
import com.exlibris.core.infra.svc.api.queue.WorkQueueApplicationException;
import com.exlibris.core.infra.svc.api.queue.WorkQueueFactory;
import com.exlibris.core.infra.svc.api.services.CacheManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.commons.io.FileUtils;

public class CacheServices {
    public static final String CONFIGURATION_MANAGER = "/ConfigurationManager/";
    public static final String GENERAL_PARAMETER = "/ConfigurationManager/GeneralParameter";
    public static final String CODETABLES_MANAGER = "/i18n/";
    public static final String PROCESS_AUTOMATION = "/pa/";
    public static final String EVENTS = "/events/";
    public static final String PARAMETERS_FOR_EVENT_TYPE = "/events/parametersForEventType";
    public static final String EVENT_CONTEXT = "/events/eventContext";
    public static final String PROPERTIES_FOR_EVENT_TYPE = "/events/propertiesForEventType";
    public static final String EVENT_KEYS = "/events/eventKeys";
    public static final String ANALYZERS_FOR_EVENT_TYPE = "/events/analyzersForEventType";
    public static final String IS_PROVENANCE_EVENT_FOR_TYPE = "/events/IsProvenanceForEventType";
    public static final String ANALIZER_TYPE = "/events/analyzerType";
    public static final String DELIVERY_SESSION = "/DeliverySession";
    public static final String ORACLE_SERVER_VERSION_NODE = "ORACLE_SERVER_VERSION_NODE";
    public static final String DELIVERY_RULE = "DELIVERY_RULE";
    public static final String PROPERTY_CONFIGURATION = "PROPERTY_CONFIGURATION";
    public static final String SOLR_TYPES_XML = "SOLR_TYPES_XML";
    public static final String SOLR_TYPES_XML_PATH = "field_types.xml";
    public static final String EXTERNAL_RESOURCE_EXPLORER = "EXTERNAL_RESOURCE_EXPLORER";
    public static final String MIME_TYPE = "MIME_TYPE";
    public static final String DROID_SIGNATURE = "DROID_SIGNATURES";
    public static final String PRESERVATION_AUDIT = "/PreservationAudit";
    public static final String UI_CUSTOMIZATION = "/UICustomization";
    public static final String UI_CUSTOMIZATION_BG = "/UICustomization_bg";
    public static final String UI_CUSTOMIZATION_ID = "UI_CUSTOMIZATION_ID";
    public static final String USER_SETTINGS = "/UserSettings";
    public static final String MENU_KEY_SETTINGS = "/MenuKeySettings";
    public static final String AUTHENTICATION_PROFILES = "/AuthenticationProfiles";
    public static final String DELIVERY_METADATA_FIELDS = "/DeliveryMetadataFields";
    public static final String SUBMISSION_FORMAT_PW = "submission_format_pw";
    public static final String UPDATE_NUMBER_QUEUE_WORKER = "/updateNumWorkers";
    private static final String UI_CUSTOMIZATION_FILE_NAME = "ui_customization_files.properties";
    private static Properties uiCustomizationSettings = null;
    private static final String DEPLOY_DIR = "/thirdparty/tomcat/rosetta-webapps/";
    public static final String METS_DNX_XSD_VERSION = "metsDnxXsdVerison";
    private static CacheManager deliverySessionCacheManager = null;
    private static ConcurrentMap generalCacheManager = null;
    private static final ExLogger logger = ExLogger.getExLogger(CacheServices.class);
    public static final String IE_DNX_FIELDS = "ieDnxFields";
    public static final String REP_DNX_FIELDS = "repDnxFields";
    public static final String FILE_DNX_FIELDS = "fileDnxFields";
    private static CacheServices instance = null;

    private CacheServices() {
    }

    public static CacheServices getInstance() {
        if (deliverySessionCacheManager == null) {
            GeneralParameterManager manager = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
            long timerInterval = 60L;
            long ttl = 1200L;
            try {
                timerInterval = Long.valueOf(manager.getParameterFromDB("delivery", "delivery_cache_interval"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                ttl = Long.valueOf(manager.getParameterFromDB("delivery", "delivery_cache_ttl"));
            }
            catch (Exception exception) {
                // empty catch block
            }
            deliverySessionCacheManager = new CacheManager(ttl, timerInterval);
            logger.info("CACHE: created deliverySessionCacheManager");
        }
        if (generalCacheManager == null) {
            generalCacheManager = new ConcurrentHashMap(16, 0.75f, 1);
            logger.info("CACHE: created generalCacheManager");
        }
        if (instance == null) {
            instance = new CacheServices();
            logger.info("CACHE: created instance of CacheServices");
        }
        return instance;
    }

    public void setCacheValue(String fqn, Map data, boolean distribute) {
        if (fqn.startsWith(DELIVERY_SESSION)) {
            deliverySessionCacheManager.put(fqn, data);
        } else if (!fqn.startsWith(EXTERNAL_RESOURCE_EXPLORER)) {
            generalCacheManager.put(fqn, data);
        }
        if (fqn.equals(SOLR_TYPES_XML)) {
            String fieldTypesFileName = InfraFSUtil.getSolrHome() + File.separator + SOLR_TYPES_XML_PATH;
            File fieldTypes = new File(fieldTypesFileName);
            try {
                FileUtils.writeStringToFile((File)fieldTypes, (String)((String)data.get("1")));
            }
            catch (IOException e) {
                logger.error("Failed to write field_types.xml to File System " + e, new String[0]);
            }
        }
        if (fqn.equals(UI_CUSTOMIZATION)) {
            this.distributeUICustomization(data);
        }
        if (fqn.contains(GENERAL_PARAMETER)) {
            DateHandler.reset();
        }
        if (fqn.contains(EXTERNAL_RESOURCE_EXPLORER)) {
            ExternalResourceExplorer.reset();
        }
        if (distribute) {
            KeyValuePair<String, Map> sharedCache = new KeyValuePair<String, Map>(fqn, data);
            this.distribute(sharedCache);
        }
    }

    public List<String> getCacheFqns() {
        ArrayList<String> allKeys = new ArrayList<String>();
        allKeys.addAll(generalCacheManager.keySet());
        allKeys.addAll(deliverySessionCacheManager.getKeys());
        return allKeys;
    }

    public Object getCache(String fqn) {
        if (fqn.startsWith(DELIVERY_SESSION)) {
            return deliverySessionCacheManager.get(fqn);
        }
        return generalCacheManager.get(fqn);
    }

    public Object getCacheValue(String fqn, String key) {
        try {
            if (fqn.startsWith(DELIVERY_SESSION)) {
                return ((Map)deliverySessionCacheManager.get(fqn)).get(key);
            }
            return ((Map)generalCacheManager.get(fqn)).get(key);
        }
        catch (Exception e) {
            logger.debug((Object)DescriptorConstants.GN_ErrorGettingFromCache, fqn, key.toString());
            return null;
        }
    }

    public void removeCache(String fqn) {
        try {
            if (fqn.startsWith(DELIVERY_SESSION)) {
                deliverySessionCacheManager.remove(fqn);
            } else {
                generalCacheManager.remove(fqn);
            }
        }
        catch (Exception e) {
            logger.debug((Object)DescriptorConstants.GN_ErrorGettingFromCache, fqn, "null");
        }
    }

    public void removeCacheValue(String fqn, String key) {
        try {
            if (fqn.startsWith(DELIVERY_SESSION)) {
                ((Map)deliverySessionCacheManager.get(fqn)).remove(key);
            } else {
                ((Map)generalCacheManager.get(fqn)).remove(key);
            }
        }
        catch (Exception e) {
            logger.debug((Object)("Failed to remove cache for " + fqn + " with key:" + key), e, new String[0]);
        }
    }

    private void distribute(KeyValuePair<String, Map> sharedCache) {
        WorkQueueFactory workQueueFactory = WorkQueueFactory.getWorkQueueFactory(KeyValuePair.class);
        WorkQueue workQueue = workQueueFactory.getWorkQueue("SHARED_CACHE_TOPIC");
        try {
            workQueue.enqueue(sharedCache, "SHARED_CACHE_TOPIC", sharedCache.getKey(), 4, QueueConstants.messageType.TOPIC);
        }
        catch (WorkQueueApplicationException e) {
            logger.error("Failed distribute cache for: " + sharedCache.getKey(), e, new String[0]);
        }
    }

    public void distributeUICustomization(Map data) {
        block11: {
            String fileSourcePath = null;
            String fileSourcePathBg = null;
            if ((String)data.get(UI_CUSTOMIZATION) != null) {
                fileSourcePath = (String)data.get(UI_CUSTOMIZATION);
            }
            if ((String)data.get(UI_CUSTOMIZATION_BG) != null) {
                fileSourcePathBg = (String)data.get(UI_CUSTOMIZATION_BG);
            }
            String uiCustomizationId = (String)data.get(UI_CUSTOMIZATION_ID);
            try {
                uiCustomizationSettings = new Properties();
                String uiCustomizationFilePath = InfraFSUtil.getSystemConfDir() + UI_CUSTOMIZATION_FILE_NAME;
                uiCustomizationSettings.load(new FileInputStream(uiCustomizationFilePath));
                String deployDir = InfraFSUtil.getSystemDir() + DEPLOY_DIR;
                Set<Object> fileNames = uiCustomizationSettings.keySet();
                if (fileSourcePath != null) {
                    for (String string : fileNames) {
                        String filePath = uiCustomizationSettings.getProperty(string);
                        File targetDirectoryDeploy = new File(deployDir + filePath);
                        File targetFileInDeploy = new File(deployDir + filePath + uiCustomizationId + File.separator + "logo-main.png");
                        File sourceFile = new File(fileSourcePath);
                        try {
                            if (!targetDirectoryDeploy.exists()) continue;
                            FileUtils.copyFile((File)sourceFile, (File)targetFileInDeploy);
                        }
                        catch (Throwable t) {
                            System.out.println("Problem copying logo to " + targetFileInDeploy.getAbsolutePath());
                        }
                    }
                }
                if (fileSourcePathBg == null) break block11;
                String filePath = uiCustomizationSettings.getProperty("BACKOFFICE");
                File file = new File(deployDir + filePath);
                File targetFileInDeploy = new File(deployDir + filePath + uiCustomizationId + File.separator + "backgroundImage.jpg");
                File sourceFile = new File(fileSourcePathBg);
                try {
                    if (file.exists()) {
                        FileUtils.copyFile((File)sourceFile, (File)targetFileInDeploy);
                    }
                }
                catch (Throwable t) {
                    System.out.println("Problem copying backgroundImage to " + targetFileInDeploy.getAbsolutePath());
                }
            }
            catch (Exception e) {
                logger.error("Error in distributing Logo from: " + fileSourcePath, new String[0]);
            }
        }
    }
}

