/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.mimetypes;

import com.exlibris.core.infra.svc.api.MimeTypeManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.services.CacheServices;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class MimeTypeUtil {
    private static final String MIME_TYPE_TABLE_KEY = "mimeTypeTable";
    private static final String FILE_EXT_TABLE_KEY = "fileExtTable";
    private static final String FORMAT_MIME_TABLE_KEY = "formatMimeTable";
    private static MimeTypeUtil mtu = null;

    public static MimeTypeUtil getMimeTypeUtil() {
        return MimeTypeUtil.getMimeTypeUtil(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MimeTypeUtil getMimeTypeUtil(boolean distributeCache) {
        Class<MimeTypeUtil> clazz = MimeTypeUtil.class;
        synchronized (MimeTypeUtil.class) {
            if (mtu == null) {
                mtu = new MimeTypeUtil(distributeCache);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return mtu;
        }
    }

    public static void reset() {
        mtu = null;
        MimeTypeUtil.getMimeTypeUtil();
    }

    private MimeTypeUtil(boolean distributeCache) {
        this.loadMapDataToCache(distributeCache);
    }

    private void loadMapDataToCache(boolean distributeCache) {
        Map<String, Map<String, String>> mimeTypCache = this.getData();
        CacheServices.getInstance().setCacheValue("MIME_TYPE", mimeTypCache, distributeCache);
    }

    private Map<String, Map<String, String>> getData() {
        MimeTypeManager manager = (MimeTypeManager)ServiceLocator.getInstance().lookUp(MimeTypeManager.class);
        List fls = manager.getFormats();
        Hashtable<String, String> mimeTypeTable = new Hashtable<String, String>();
        HashMap<String, String> fileExtTable = new HashMap<String, String>();
        HashMap<String, String> formatMimeTable = new HashMap<String, String>();
        for (Object[] fl : fls) {
            String fileExtensionsList = (String)fl[0];
            String mimeTypeString = (String)fl[1];
            String formatRegId = (String)fl[2];
            mimeTypeString = mimeTypeString == null ? "" : mimeTypeString;
            formatMimeTable.put(formatRegId, mimeTypeString);
            if (!StringUtils.isBlank((String)fileExtensionsList)) {
                for (String extension : fileExtensionsList.split(",")) {
                    String fileExtString = extension.trim().toLowerCase();
                    if (!mimeTypeTable.containsKey(fileExtString)) {
                        mimeTypeTable.put(fileExtString, mimeTypeString);
                    }
                    if (StringUtils.isBlank((String)mimeTypeString) || fileExtTable.containsKey(mimeTypeString)) continue;
                    fileExtTable.put(mimeTypeString, fileExtString);
                }
                continue;
            }
            if (StringUtils.isBlank((String)mimeTypeString) || fileExtTable.containsKey(mimeTypeString)) continue;
            mimeTypeString = mimeTypeString.trim().toLowerCase();
            fileExtTable.put(mimeTypeString, "");
        }
        HashMap<String, Map<String, String>> mapData = new HashMap<String, Map<String, String>>();
        mapData.put(MIME_TYPE_TABLE_KEY, mimeTypeTable);
        mapData.put(FILE_EXT_TABLE_KEY, fileExtTable);
        mapData.put(FORMAT_MIME_TABLE_KEY, formatMimeTable);
        return mapData;
    }

    private Map<String, String> getValueMapFromCache(String mapKey) {
        Map valueMap = (Map)CacheServices.getInstance().getCacheValue("MIME_TYPE", mapKey);
        return valueMap;
    }

    public Map<String, String> getMimeTypeTable() {
        return this.getValueMapFromCache(MIME_TYPE_TABLE_KEY);
    }

    public Map<String, String> getFileExtTable() {
        return this.getValueMapFromCache(FILE_EXT_TABLE_KEY);
    }

    public Map<String, String> getFormatMimeTable() {
        return this.getValueMapFromCache(FORMAT_MIME_TABLE_KEY);
    }

    public String getMimeType(String extension) {
        return this.getMimeTypeTable().get(extension.trim().toLowerCase());
    }

    public String getMimeTypeByFormat(String formatRegistryId) {
        return this.getFormatMimeTable().get(formatRegistryId);
    }

    public String getFileExtension(String mimeType) {
        return this.getFileExtTable().get(mimeType.trim().toLowerCase());
    }
}

