/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.searcher;

import java.io.IOException;
import java.util.List;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.matcher.Matcher;
import net.byteseek.searcher.AbstractSearcher;
import net.byteseek.searcher.SearchResult;
import net.byteseek.searcher.SearchUtils;
import net.byteseek.utils.ArgUtils;

public final class MatcherSearcher
extends AbstractSearcher<Matcher> {
    private final Matcher matcher;

    public MatcherSearcher(Matcher matcher) {
        ArgUtils.checkNullObject(matcher, "matcher");
        this.matcher = matcher;
    }

    @Override
    public List<SearchResult<Matcher>> searchForwards(WindowReader reader, long fromPosition, long toPosition) throws IOException {
        Window window;
        long searchPosition;
        Matcher theMatcher = this.matcher;
        long l = searchPosition = fromPosition > 0L ? fromPosition : 0L;
        while (searchPosition <= toPosition && (window = reader.getWindow(searchPosition)) != null) {
            long finalPosition;
            int searchLength = window.length() - reader.getWindowOffset(searchPosition);
            long searchEndPosition = searchPosition + (long)searchLength - 1L;
            long l2 = finalPosition = toPosition < searchEndPosition ? toPosition : searchEndPosition;
            while (searchPosition <= finalPosition) {
                if (theMatcher.matches(reader, searchPosition)) {
                    return SearchUtils.singleResult(searchPosition, theMatcher);
                }
                ++searchPosition;
            }
        }
        return SearchUtils.noResults();
    }

    @Override
    public List<SearchResult<Matcher>> searchForwards(byte[] bytes, int fromPosition, int toPosition) {
        int searchPosition;
        Matcher theMatcher = this.matcher;
        int arrayEndPosition = bytes.length - 1;
        int searchEndPosition = toPosition < arrayEndPosition ? toPosition : arrayEndPosition;
        int n = searchPosition = fromPosition > 0 ? fromPosition : 0;
        while (searchPosition <= searchEndPosition) {
            if (theMatcher.matches(bytes, searchPosition)) {
                return SearchUtils.singleResult(searchPosition, theMatcher);
            }
            ++searchPosition;
        }
        return SearchUtils.noResults();
    }

    @Override
    public List<SearchResult<Matcher>> searchBackwards(WindowReader reader, long fromPosition, long toPosition) throws IOException {
        Matcher theMatcher = this.matcher;
        long endSearchPosition = toPosition > 0L ? toPosition : 0L;
        for (long searchPosition = this.withinLength(reader, fromPosition); searchPosition >= endSearchPosition; --searchPosition) {
            if (!theMatcher.matches(reader, searchPosition)) continue;
            return SearchUtils.singleResult(searchPosition, theMatcher);
        }
        return SearchUtils.noResults();
    }

    @Override
    public List<SearchResult<Matcher>> searchBackwards(byte[] bytes, int fromPosition, int toPosition) {
        int searchPosition;
        Matcher theMatcher = this.matcher;
        int lastPossiblePosition = bytes.length - 1;
        int endSearchPosition = toPosition > 0 ? toPosition : 0;
        int n = searchPosition = fromPosition < lastPossiblePosition ? fromPosition : lastPossiblePosition;
        while (searchPosition >= endSearchPosition) {
            if (theMatcher.matches(bytes, searchPosition)) {
                return SearchUtils.singleResult(searchPosition, theMatcher);
            }
            --searchPosition;
        }
        return SearchUtils.noResults();
    }

    @Override
    public void prepareForwards() {
    }

    @Override
    public void prepareBackwards() {
    }

    public String toString() {
        return this.getClass().getSimpleName() + '[' + this.matcher + ']';
    }
}

