/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.util;

import com.exlibris.core.infra.common.normalizers.NormalizerUtil;
import com.exlibris.core.infra.model.annotation.Searchable;
import com.exlibris.digitool.repository.sets.xmlbeans.Field;
import com.exlibris.digitool.repository.sets.xmlbeans.FieldSet;
import com.exlibris.digitool.repository.sets.xmlbeans.OpType;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Iterator;
import org.apache.commons.lang.StringEscapeUtils;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;

public class IndexXmlUtil {
    private static final String ALL = "all";
    private static final String PRODUCER = "HDpProducer";
    private static final String DEPOSIT_ACTIVITY_ID = "deposit_activity_id";
    private static final String SIP_ID = "sip_Id";
    private static final String AUTHORATIVE_NAME = "AUTHORATIVE_NAME";
    private static final String DEPOSIT_ID = "DEPOSIT_ID";

    public static String generateIndexXml(Object obj) {
        return IndexXmlUtil.generateIndexXmlForObject(obj).asXML();
    }

    public static Element generateIndexXmlForObject(Object obj) {
        Method[] methods = obj.getClass().getMethods();
        Element rootElement = DocumentFactory.getInstance().createElement("index");
        for (int i = 0; i < methods.length; ++i) {
            Element subElement = IndexXmlUtil.generateIndexXmlForMethod(obj, methods[i]);
            if (subElement == null) continue;
            rootElement.add(subElement);
        }
        return rootElement;
    }

    private static Element generateIndexXmlForMethod(Object obj, Method method) {
        if (method == null || obj == null) {
            return null;
        }
        if (!method.isAnnotationPresent(Searchable.class)) {
            return null;
        }
        String methodName = method.getName();
        if (!methodName.startsWith("get")) {
            return null;
        }
        Object returnObject = null;
        try {
            returnObject = method.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
        if (returnObject == null) {
            return null;
        }
        String elementName = methodName.substring(3, 4).toLowerCase() + methodName.substring(4);
        Element element = DocumentFactory.getInstance().createElement(elementName);
        if (returnObject instanceof Collection) {
            Collection collection = (Collection)returnObject;
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                element.add(IndexXmlUtil.generateIndexXmlForObject(iterator.next()));
            }
        } else {
            String elementValue = returnObject.toString();
            elementValue = NormalizerUtil.normalizeWithProfileName("generic", elementValue);
            element.addText(elementValue);
        }
        return element;
    }

    public static void addSearchToFS(String searchText, String searchCriteria, FieldSet fieldSet) {
        if (searchCriteria != null) {
            if (searchCriteria.equals(DEPOSIT_ACTIVITY_ID) || searchCriteria.equals(SIP_ID) || searchCriteria.equals(DEPOSIT_ID)) {
                IndexXmlUtil.addSearchToFS(searchText, searchCriteria, fieldSet, OpType.EXACT, null);
            } else if (searchCriteria.equals(AUTHORATIVE_NAME)) {
                IndexXmlUtil.addSearchToFS(searchText, searchCriteria, fieldSet, OpType.WITHIN, PRODUCER);
            } else {
                IndexXmlUtil.addSearchToFS(searchText, searchCriteria, fieldSet, OpType.WITHIN, null);
            }
        }
    }

    public static void addSearchToFS(String searchText, String searchCriteria, FieldSet containsFieldSet, OpType.Enum opType, String table) {
        if (searchText == null || searchText.trim().length() == 0) {
            return;
        }
        Field pair1 = containsFieldSet.addNewField();
        pair1.setStringValue(StringEscapeUtils.escapeSql((String)searchText));
        pair1.setOp(opType);
        pair1.setTable(table);
        if (searchCriteria == null || searchCriteria.equals(ALL)) {
            pair1.setOp(OpType.NOT);
        } else {
            pair1.setKey(StringEscapeUtils.escapeSql((String)searchCriteria));
        }
    }
}

