/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.authentication;

import com.exlibris.core.infra.Common;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.security.UserPrincipal;
import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import io.jsonwebtoken.Claims;
import io.jsonwebtoken.ExpiredJwtException;
import io.jsonwebtoken.JwtBuilder;
import io.jsonwebtoken.JwtException;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import io.jsonwebtoken.SignatureException;
import io.jsonwebtoken.impl.crypto.MacProvider;
import java.util.Base64;
import java.util.Map;
import javax.crypto.SecretKey;
import org.apache.commons.lang.StringUtils;
import org.joda.time.DateTime;

public class JwtUtil {
    private static final ExLogger logger = ExLogger.getExLogger(JwtUtil.class);
    private static final String INSTITUTION = "institution";
    private static final String AUTHENTICATION_HANDLE = "authenticationHandle";
    private static final String AUTHENTICATION_MODE = "authenticationMode";
    private static final String AUTHENTICATION_PARAMETERS = "authParameters";
    private static final int TOKEN_EXPIRATION_TIME = 2;
    public static final String USER_IP = "userIp";

    public static String generateJwtToken(UserPrincipal userPrincipal, String userIp) {
        Claims claims = Jwts.claims().setSubject(userPrincipal.getUserDetails().getUserName());
        claims.put((Object)INSTITUTION, (Object)userPrincipal.getInstitutionCode());
        claims.put((Object)AUTHENTICATION_HANDLE, (Object)userPrincipal.getPdsHandle());
        claims.put((Object)AUTHENTICATION_MODE, (Object)userPrincipal.getAuthenticationMode());
        claims.put((Object)AUTHENTICATION_PARAMETERS, userPrincipal.getAuthenticationParameters());
        claims.put((Object)USER_IP, (Object)userIp);
        DateTime currentTime = new DateTime();
        JwtBuilder jwt = Jwts.builder().setClaims(claims).setExpiration(currentTime.plusMinutes(2).toDate()).signWith(SignatureAlgorithm.HS256, JwtUtil.getTokenSigningKey());
        return jwt.compact();
    }

    public static String generateJwtTokenForReportsUser(String inst, String key) {
        Claims claims = Jwts.claims().setSubject("remotereports");
        claims.put((Object)INSTITUTION, (Object)inst);
        claims.put((Object)AUTHENTICATION_MODE, (Object)Common.AuthenticationMode.LOCAL);
        DateTime currentTime = new DateTime();
        JwtBuilder jwt = Jwts.builder().setClaims(claims).setExpiration(currentTime.plusMinutes(2).toDate()).signWith(SignatureAlgorithm.HS256, key);
        return jwt.compact();
    }

    public static UserPrincipal parseJwtToken(String jwtToken, String userIp, boolean isRemoteReport) {
        try {
            String key = isRemoteReport ? JwtUtil.getRemoteReportTokenSigningKey() : JwtUtil.getTokenSigningKey();
            Claims claims = (Claims)Jwts.parser().setSigningKey(key).parseClaimsJws(jwtToken).getBody();
            UserPrincipal userPrincipal = new UserPrincipal(claims.getSubject());
            userPrincipal.setUserName(claims.getSubject());
            userPrincipal.setInstitutionCode((String)claims.get((Object)INSTITUTION));
            userPrincipal.setPdsHandle((String)claims.get((Object)AUTHENTICATION_HANDLE));
            userPrincipal.setAuthenticationMode(Common.AuthenticationMode.valueOf((String)claims.get((Object)AUTHENTICATION_MODE)));
            userPrincipal.setAuthenticationParameters((Map)claims.get((Object)AUTHENTICATION_PARAMETERS));
            return userPrincipal;
        }
        catch (ExpiredJwtException e) {
            logger.error("Jwt Token Expired", (Exception)((Object)e), new String[0]);
        }
        catch (SignatureException e) {
            logger.error("Invalid Jwt Token Signature", (Exception)((Object)e), new String[0]);
        }
        catch (JwtException e) {
            logger.error("Failed to parse JWT Token", (Exception)((Object)e), new String[0]);
        }
        return null;
    }

    private static String getTokenSigningKey() {
        GeneralParameterManager generalParameterManager = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
        String signingKey = generalParameterManager.getParameter("authentication", "jwt_token_signing_key");
        if (StringUtils.isBlank((String)signingKey)) {
            SecretKey secretKey = MacProvider.generateKey((SignatureAlgorithm)SignatureAlgorithm.HS256);
            signingKey = Base64.getEncoder().encodeToString(secretKey.getEncoded());
            generalParameterManager.updateGeneralParameterValue("authentication", "jwt_token_signing_key", signingKey);
        }
        return signingKey;
    }

    private static String getRemoteReportTokenSigningKey() {
        GeneralParameterManager generalParameterManager = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
        return generalParameterManager.getParameter("authentication", "remote_access_key");
    }

    public static void setRemoteReportTokenSigningKey() {
        GeneralParameterManager generalParameterManager = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
        String signingKey = generalParameterManager.getParameter("authentication", "remote_access_key");
        if (StringUtils.isBlank((String)signingKey)) {
            SecretKey secretKey = MacProvider.generateKey((SignatureAlgorithm)SignatureAlgorithm.HS256);
            signingKey = Base64.getEncoder().encodeToString(secretKey.getEncoded());
            generalParameterManager.updateGeneralParameterValue("authentication", "remote_access_key", signingKey);
            logger.info("Setting 'remote_access_key' parameter");
        }
    }
}

