/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.html;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import org.apache.commons.lang.StringEscapeUtils;
import org.owasp.esapi.ESAPI;
import org.owasp.esapi.Encoder;

public class HTMLNormalizer {
    private static Encoder encoder = ESAPI.encoder();
    private static final ExLogger logger = ExLogger.getExLogger(HTMLNormalizer.class);

    public static String normalize(String s) {
        return StringEscapeUtils.escapeHtml((String)s);
    }

    public static String deNormalize(String s) {
        return StringEscapeUtils.unescapeHtml((String)s);
    }

    public static String htmlNormalize(String s) {
        try {
            return encoder.encodeForHTML(s);
        }
        catch (Exception e) {
            logger.error("ESAPI encoding exception: failed to encode html: " + s, e, new String[0]);
            return HTMLNormalizer.normalize(s);
        }
    }

    public static String htmlAttributeNormalize(String s) {
        try {
            return encoder.encodeForHTMLAttribute(s);
        }
        catch (Exception e) {
            logger.error("ESAPI encoding exception: failed to encode html attribute: " + s, e, new String[0]);
            return HTMLNormalizer.normalize(s);
        }
    }

    public static String javaScriptNormalize(String s) {
        try {
            return encoder.encodeForJavaScript(s);
        }
        catch (Exception e) {
            logger.error("ESAPI encoding exception: failed to encode java script string: " + s, e, new String[0]);
            return HTMLNormalizer.normalize(s);
        }
    }

    public static String cssNormalize(String s) {
        try {
            return encoder.encodeForCSS(s);
        }
        catch (Exception e) {
            logger.error("ESAPI encoding exception: failed to encode css: " + s, e, new String[0]);
            return HTMLNormalizer.normalize(s);
        }
    }

    public static String urlNormalize(String s) {
        try {
            return encoder.encodeForURL(s);
        }
        catch (Exception e) {
            logger.error("ESAPI encoding exception: failed to encode url: " + s, e, new String[0]);
            return HTMLNormalizer.normalize(s);
        }
    }
}

