/*
 * Decompiled with CFR 0.152.
 */
package org.jwat.common;

import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;

public class ByteCountingPushBackInputStream
extends PushbackInputStream {
    public static final int READLINE_INITIAL_SIZE = 128;
    protected int pushback_size;
    protected long consumed = 0L;
    protected long counter = 0L;

    public ByteCountingPushBackInputStream(InputStream in, int size) {
        super(in, size);
        this.pushback_size = size;
    }

    public int getPushbackSize() {
        return this.pushback_size;
    }

    public long getConsumed() {
        return this.consumed;
    }

    public void setCounter(long bytes) {
        this.counter = bytes;
    }

    public long getCounter() {
        return this.counter;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public synchronized void mark(int readlimit) {
    }

    @Override
    public synchronized void reset() throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int read() throws IOException {
        int b = super.read();
        if (b != -1) {
            ++this.consumed;
            ++this.counter;
        }
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int bytesRead = super.read(b, off, len);
        if (bytesRead > 0) {
            this.consumed += (long)bytesRead;
            this.counter += (long)bytesRead;
        }
        return bytesRead;
    }

    @Override
    public long skip(long n) throws IOException {
        long bytesSkipped = super.skip(n);
        this.consumed += bytesSkipped;
        this.counter += bytesSkipped;
        return bytesSkipped;
    }

    @Override
    public void unread(int b) throws IOException {
        super.unread(b);
        --this.consumed;
        --this.counter;
    }

    @Override
    public void unread(byte[] b) throws IOException {
        this.unread(b, 0, b.length);
    }

    @Override
    public void unread(byte[] b, int off, int len) throws IOException {
        super.unread(b, off, len);
        this.consumed -= (long)len;
        this.counter -= (long)len;
    }

    public String readLine() throws IOException {
        StringBuffer sb = new StringBuffer(128);
        while (true) {
            int b;
            if ((b = this.read()) == -1) {
                return null;
            }
            if (b == 10) break;
            if (b == 13) continue;
            sb.append((char)b);
        }
        return sb.toString();
    }

    public int readFully(byte[] buffer) throws IOException {
        int readOffset = 0;
        int readRemaining = buffer.length;
        int readLast = 0;
        while (readRemaining > 0 && readLast != -1) {
            readLast = this.read(buffer, readOffset += readLast, readRemaining -= readLast);
        }
        if (readRemaining > 0) {
            this.unread(buffer, 0, readOffset);
            readOffset = 0;
        }
        return readOffset;
    }

    public int peek(byte[] buffer) throws IOException {
        int readOffset = 0;
        int readRemaining = buffer.length;
        int readLast = 0;
        while (readRemaining > 0 && readLast != -1) {
            readLast = this.read(buffer, readOffset += readLast, readRemaining -= readLast);
        }
        if (readOffset > 0) {
            this.unread(buffer, 0, readOffset);
        }
        return readOffset;
    }
}

