/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.component;

import com.sun.jimi.core.Jimi;
import com.sun.jimi.core.filters.ReplicatingScaleFilter;
import com.sun.jimi.core.util.GraphicsUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Toolkit;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.CropImageFilter;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageFilter;
import java.net.URL;

public class JimiCanvasLW
extends Component {
    public static final int EAST = 0;
    public static final int NORTH = 1;
    public static final int NORTHEAST = 2;
    public static final int NORTHWEST = 3;
    public static final int SOUTH = 4;
    public static final int SOUTHEAST = 5;
    public static final int SOUTHWEST = 6;
    public static final int WEST = 7;
    public static final int CENTER = 8;
    public static final int BEST_FIT = 0;
    public static final int CROP_AS_NECESSARY = 1;
    public static final int SCALE = 2;
    public static final int SCROLL = 3;
    public static final int FIT_TO_WIDTH = 4;
    public static final int AREA_AVERAGING = 0;
    public static final int REPLICATE = 1;
    protected transient Image myImage;
    protected URL myImageLocation;
    protected boolean willSizeToFit = false;
    protected int justificationPolicy = 8;
    protected int resizePolicy = 3;
    protected int scalingPolicy = 1;
    private transient Image cacheImage;
    private int lastWidth;
    private int lastHeight;
    private int lastResizePolicy;
    private int lastScalingPolicy;
    private int lastJustificationPolicy;
    private int fitWidth = -1;

    public JimiCanvasLW() {
    }

    public JimiCanvasLW(Image image) {
        this();
        this.myImage = image;
        this.myImageLocation = null;
    }

    public JimiCanvasLW(URL uRL) {
        this();
        this.myImage = null;
        this.myImageLocation = uRL;
    }

    protected void LoadImage() {
        if (this.myImageLocation == null) {
            return;
        }
        Image image = Jimi.getImage(this.myImageLocation);
        MediaTracker mediaTracker = new MediaTracker(this);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
            if (!mediaTracker.isErrorAny()) {
                this.setImage(image);
            }
        }
        catch (InterruptedException interruptedException) {}
    }

    private synchronized void doResize() {
        if (this.myImage == null) {
            return;
        }
        this.setSize(new Dimension(this.myImage.getWidth(this), this.myImage.getHeight(this)));
        Container container = this.getParent();
        if (container != null) {
            container.invalidate();
            container.layout();
        }
    }

    protected Image getCacheImage() {
        if (this.cacheImage == null) {
            this.cacheImage = this.getResizedImage(this.myImage, this.size().width, this.size().height, this.resizePolicy, this.justificationPolicy);
        }
        return this.cacheImage;
    }

    public Image getImage() {
        return this.myImage;
    }

    public URL getImageLocation() {
        return this.myImageLocation;
    }

    public int getJustificationPolicy() {
        return this.justificationPolicy;
    }

    public Dimension getPreferredSize() {
        if (this.myImage != null && this.getWillSizeToFit()) {
            if (this.getResizePolicy() == 4) {
                Image image = this.getCacheImage();
                if (image != null) {
                    return new Dimension(image.getWidth(null), image.getHeight(null));
                }
            } else {
                return new Dimension(this.myImage.getWidth(null), this.myImage.getHeight(null));
            }
        }
        return super.getPreferredSize();
    }

    public int getResizePolicy() {
        return this.resizePolicy;
    }

    Image getResizedImage(Image image, int n, int n2, int n3, int n4) {
        int n5 = image.getWidth(this);
        int n6 = image.getHeight(this);
        if (n3 == 3) {
            return image;
        }
        if (n3 == 1) {
            int n7 = 0;
            int n8 = 0;
            int n9 = n5 - n;
            int n10 = n6 - n2;
            if (n9 < 0) {
                n9 = 0;
            }
            if (n10 < 0) {
                n10 = 0;
            }
            if (n9 == 0 && n10 == 0) {
                return image;
            }
            int n11 = n9 / 2;
            int n12 = n10 / 2;
            int n13 = n < n5 ? n : n5;
            int n14 = n2 < n6 ? n2 : n6;
            switch (n4) {
                case 8: {
                    n7 = n11;
                    n8 = n12;
                    break;
                }
                case 3: {
                    n7 = 0;
                    n8 = 0;
                    break;
                }
                case 7: {
                    n7 = 0;
                    n8 = n12;
                    break;
                }
                case 6: {
                    n7 = 0;
                    n8 = n10;
                    break;
                }
                case 4: {
                    n7 = n11;
                    n8 = n10;
                    break;
                }
                case 5: {
                    n7 = n9;
                    n8 = n10;
                    break;
                }
                case 0: {
                    n7 = n9;
                    n8 = n12;
                    break;
                }
                case 2: {
                    n7 = n9;
                    n8 = 0;
                    break;
                }
                case 1: {
                    n7 = n11;
                    n8 = 0;
                    break;
                }
            }
            CropImageFilter cropImageFilter = new CropImageFilter(n7, n8, n5, n6);
            FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), cropImageFilter);
            Image image2 = Toolkit.getDefaultToolkit().createImage(filteredImageSource);
            image.flush();
            GraphicsUtils.waitForImage(this, image2);
            return image2;
        }
        if (n3 == 2) {
            ImageFilter imageFilter = this.getScalingPolicy() == 0 ? new AreaAveragingScaleFilter(n, n2) : new ReplicatingScaleFilter(n, n2);
            FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), imageFilter);
            return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
        }
        if (n3 == 0) {
            int n15;
            int n16;
            float f = (float)n / (float)n5;
            float f2 = (float)n2 / (float)n6;
            if (f < f2) {
                n16 = (int)((float)n5 * f);
                n15 = (int)((float)n6 * f);
            } else {
                n16 = (int)((float)n5 * f2);
                n15 = (int)((float)n6 * f2);
            }
            ImageFilter imageFilter = this.getScalingPolicy() == 0 ? new AreaAveragingScaleFilter(n16, n15) : new ReplicatingScaleFilter(n16, n15);
            FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), imageFilter);
            return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
        }
        if (n5 < this.fitWidth) {
            return image;
        }
        int n17 = this.fitWidth == -1 ? n : this.fitWidth;
        float f = (float)n17 / (float)n5;
        int n18 = (int)((float)n6 * f);
        if (this.cacheImage != null && this.cacheImage.getWidth(null) == n17 && this.cacheImage.getHeight(null) == n18) {
            return this.cacheImage;
        }
        ImageFilter imageFilter = this.getScalingPolicy() == 0 ? new AreaAveragingScaleFilter(n17, n18) : new ReplicatingScaleFilter(n17, n18);
        FilteredImageSource filteredImageSource = new FilteredImageSource(image.getSource(), imageFilter);
        return Toolkit.getDefaultToolkit().createImage(filteredImageSource);
    }

    public int getScalingPolicy() {
        return this.scalingPolicy;
    }

    public boolean getWillSizeToFit() {
        return this.willSizeToFit;
    }

    public synchronized void paint(Graphics graphics) {
        if (this.myImage == null) {
            graphics.setColor(this.getForeground());
            graphics.fillRect(0, 0, this.size().width, this.size().height);
            return;
        }
        int n = 0;
        int n2 = 0;
        int n3 = this.size().width;
        int n4 = this.size().height;
        if (this.cacheImage == null || n3 != this.lastWidth || n4 != this.lastHeight || this.resizePolicy != this.lastResizePolicy || this.justificationPolicy != this.lastJustificationPolicy) {
            this.cacheImage = this.getResizedImage(this.myImage, n3, n4, this.resizePolicy, this.justificationPolicy);
            this.lastWidth = n3;
            this.lastHeight = n4;
            this.lastResizePolicy = this.resizePolicy;
            this.lastJustificationPolicy = this.justificationPolicy;
        }
        int n5 = this.cacheImage.getWidth(this);
        int n6 = this.cacheImage.getHeight(this);
        switch (this.justificationPolicy) {
            case 8: {
                n = (n3 - n5) / 2;
                n2 = (n4 - n6) / 2;
                break;
            }
            case 3: {
                n = 0;
                n2 = 0;
                break;
            }
            case 2: {
                n = n3 - n5;
                n2 = 0;
                break;
            }
            case 1: {
                n = (n3 - n5) / 2;
                n2 = 0;
                break;
            }
            case 4: {
                n = (n3 - n5) / 2;
                n2 = n4 - n6;
                break;
            }
            case 6: {
                n = 0;
                n2 = n4 - n6;
                break;
            }
            case 5: {
                n = n3 - n5;
                n2 = n4 - n6;
                break;
            }
            case 0: {
                n = n3 - n5;
                n2 = (n4 - n6) / 2;
                break;
            }
            case 7: {
                n = 0;
                n2 = (n4 - n6) / 2;
                break;
            }
        }
        graphics.setColor(this.getForeground());
        graphics.fillRect(0, 0, n3, n4);
        graphics.drawImage(this.cacheImage, n, n2, n5, n6, this);
    }

    public void setFitWidth(int n) {
        this.fitWidth = n;
    }

    public synchronized void setImage(Image image) {
        if (this.cacheImage != null) {
            this.cacheImage.flush();
            this.cacheImage = null;
        }
        if (this.myImage != null) {
            this.myImage.flush();
        }
        this.myImage = image;
        if (this.willSizeToFit || this.getResizePolicy() == 4) {
            this.doResize();
        }
        this.repaint();
    }

    public synchronized void setImageLocation(URL uRL) {
        this.myImageLocation = uRL;
        this.LoadImage();
    }

    public synchronized void setJustificationPolicy(int n) {
        this.justificationPolicy = n;
    }

    public synchronized void setResizePolicy(int n) {
        this.resizePolicy = n;
    }

    public synchronized void setScalingPolicy(int n) {
        this.scalingPolicy = n;
    }

    public synchronized void setWillSizeToFit(boolean bl) {
        this.willSizeToFit = bl;
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }
}

