/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.tools;

import com.exlibris.core.infra.common.cache.SessionUtils;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.util.sorter.ExComparator;
import com.exlibris.core.infra.model.codetables.HCodeTables;
import com.exlibris.core.infra.svc.api.CodeTablesManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.repository.persistence.digitalentity.HDeControl;
import java.util.ArrayList;
import java.util.List;

public class PreservationTypeComparator
extends ExComparator<HDeControl> {
    private static final ExLogger logger = ExLogger.getExLogger(PreservationTypeComparator.class);
    List<String> preservationTypeList = new ArrayList<String>();

    public PreservationTypeComparator() {
        ArrayList<String> preservetionTypeSort = new ArrayList<String>();
        CodeTablesManager codeTableManager = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
        List<HCodeTables> PTCodeTables = codeTableManager.findEnabledCodeTableByLanguageAndNameNoCopy(SessionUtils.getSessionLanguage(), "PreservationType", "CRS00");
        if (PTCodeTables == null) {
            logger.error("PreservationType codetable not found.", new String[0]);
        } else {
            for (HCodeTables codeTable : PTCodeTables) {
                preservetionTypeSort.add(codeTable.getCode());
            }
        }
        this.preservationTypeList = preservetionTypeSort;
    }

    public PreservationTypeComparator(List<String> preservationTypeList) {
        this.preservationTypeList = preservationTypeList;
    }

    @Override
    public int compareObj(HDeControl control1, HDeControl control2) {
        int listLength;
        if (control1.getPreservationType().equals(control2.getPreservationType())) {
            return 0;
        }
        if (this.preservationTypeList == null || this.preservationTypeList.size() < 1) {
            return 0;
        }
        int deptIdx1 = listLength = this.preservationTypeList.size();
        int deptIdx2 = listLength;
        for (int index = 0; index < listLength && (deptIdx1 == listLength || deptIdx2 == listLength); ++index) {
            if (this.preservationTypeList.get(index).equals(control1.getPreservationType())) {
                deptIdx1 = index;
                continue;
            }
            if (!this.preservationTypeList.get(index).equals(control2.getPreservationType())) continue;
            deptIdx2 = index;
        }
        return deptIdx1 - deptIdx2;
    }
}

