/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.packer.gui.sipView;

import ch.docuteam.darc.util.mets.DuplicateFinder;
import ch.docuteam.darc.util.mets.DuplicateNodeFile;
import ch.docuteam.tools.gui.GridBagPanel;
import ch.docuteam.tools.translations.I18N;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.BevelBorder;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;

public class DuplicatesTable
extends JPanel {
    private static final long serialVersionUID = 1L;
    private JTable table;
    private DuplicatesTableModel duplicatesTableModel;

    public DuplicatesTable(List<DuplicateNodeFile> duplicateList, boolean withoutHeader) {
        Comparator<DuplicateNodeFile> comparator = new Comparator<DuplicateNodeFile>(){

            @Override
            public int compare(DuplicateNodeFile f1, DuplicateNodeFile f2) {
                return (f1.getPath() + f1.getLabel()).compareToIgnoreCase(f2.getPath() + f2.getLabel());
            }
        };
        Collections.sort(duplicateList, comparator);
        this.duplicatesTableModel = new DuplicatesTableModel(duplicateList);
        this.table = new JTable(this.duplicatesTableModel);
        this.table.setSelectionMode(0);
        this.table.getColumnModel().getColumn(0).setMaxWidth(120);
        this.table.getColumnModel().getColumn(2).setMinWidth(300);
        this.table.getColumnModel().getColumn(0).setCellRenderer(new CheckBoxCellRenderer());
        if (withoutHeader) {
            this.table.setTableHeader(null);
        }
        JCheckBox checkBox = new JCheckBox();
        CheckBoxCellEditor cellEditor = new CheckBoxCellEditor(checkBox);
        this.table.getColumnModel().getColumn(0).setCellEditor(cellEditor);
        GridBagPanel gridBag = new GridBagPanel((Border)new BevelBorder(1), new Insets(1, 1, 1, 1));
        JScrollPane component = new JScrollPane(this.table);
        component.setPreferredSize(new Dimension(850, 100));
        gridBag.add((Component)component, 1, 1, 1, 1, 10, 2, 1.0, 0.1);
        this.add((Component)gridBag);
    }

    List<DuplicateNodeFile> getSelected() {
        List<DuplicateNodeFile> duplicateNodeFileList = this.duplicatesTableModel.getDuplicateNodeFileList();
        ArrayList<DuplicateNodeFile> returnList = new ArrayList<DuplicateNodeFile>();
        for (DuplicateNodeFile duplicate : duplicateNodeFileList) {
            if (!duplicate.isSelectedForDeletion()) continue;
            returnList.add(duplicate);
        }
        if (this.allSelected(duplicateNodeFileList, returnList)) {
            return Collections.emptyList();
        }
        return returnList;
    }

    void clearSelection() {
        this.duplicatesTableModel.clearSelection();
        this.table.repaint();
    }

    private boolean allSelected(List<DuplicateNodeFile> allItems, List<DuplicateNodeFile> selectedItems) {
        return selectedItems.containsAll(allItems);
    }

    class CheckBoxCellEditor
    extends DefaultCellEditor
    implements ActionListener {
        private static final long serialVersionUID = 1L;

        public CheckBoxCellEditor(JCheckBox checkBox) {
            super(checkBox);
            super.setClickCountToStart(1);
            checkBox.addActionListener(this);
        }

        @Override
        public JCheckBox getComponent() {
            return (JCheckBox)super.getComponent();
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            DuplicateNodeFile selectedItem = ((DuplicatesTableModel)DuplicatesTable.this.table.getModel()).getSelectedDuplicateNodeFile();
            boolean allAreSelected = DuplicateFinder.areAllOtherItemsSelected(DuplicatesTable.this.duplicatesTableModel.getDuplicateNodeFileList(), selectedItem);
            if (!allAreSelected) {
                selectedItem.setSelectedForDeletion(true);
            } else {
                this.getComponent().setSelected(false);
                JOptionPane.showMessageDialog(DuplicatesTable.this.table, I18N.translate((String)"MessageCannotRemoveAllDuplicates"), I18N.translate((String)"MessageTitleCannotRemoveAllDuplicates"), 2);
            }
        }
    }

    class CheckBoxCellRenderer
    extends JCheckBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        CheckBoxCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object selectedForDeletion, boolean isSelected, boolean hasFocus, int row, int column) {
            this.setSelected((Boolean)selectedForDeletion);
            return this;
        }
    }

    class DuplicatesTableModel
    extends AbstractTableModel {
        private static final long serialVersionUID = 1L;
        List<DuplicateNodeFile> duplicateList;

        DuplicatesTableModel(List<DuplicateNodeFile> allDuplicatesList_) {
            this.duplicateList = allDuplicatesList_;
        }

        @Override
        public int getColumnCount() {
            return 3;
        }

        @Override
        public int getRowCount() {
            return this.duplicateList.size();
        }

        @Override
        public Object getValueAt(int row, int column) {
            if (column == 1) {
                return this.duplicateList.get(row).getLabel();
            }
            if (column == 2) {
                return this.duplicateList.get(row).getPath();
            }
            return this.duplicateList.get(row).isSelectedForDeletion();
        }

        @Override
        public void setValueAt(Object aValue, int rowIndex, int columnIndex) {
            if (columnIndex == 0) {
                DuplicateNodeFile duplicateNodeFile = this.getSelectedDuplicateNodeFile();
                boolean allAreSelected = DuplicateFinder.areAllOtherItemsSelected(DuplicatesTable.this.duplicatesTableModel.getDuplicateNodeFileList(), duplicateNodeFile);
                if (!allAreSelected) {
                    duplicateNodeFile.setSelectedForDeletion((Boolean)aValue);
                }
            }
        }

        public void clearSelection() {
            for (DuplicateNodeFile duplicate : this.duplicateList) {
                duplicate.setSelectedForDeletion(false);
            }
        }

        @Override
        public String getColumnName(int column) {
            switch (column) {
                case 0: {
                    return I18N.translate((String)"DuplicatesTableSelect");
                }
                case 1: {
                    return I18N.translate((String)"DuplicatesTableFileName");
                }
                case 2: {
                    return I18N.translate((String)"DuplicatesTablePath");
                }
            }
            return "";
        }

        @Override
        public boolean isCellEditable(int row, int column) {
            return column == 0;
        }

        DuplicateNodeFile getSelectedDuplicateNodeFile() {
            int selectedRow = DuplicatesTable.this.table.getSelectedRow();
            return this.duplicateList.get(selectedRow);
        }

        List<DuplicateNodeFile> getDuplicateNodeFileList() {
            return this.duplicateList;
        }
    }
}

