/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.domain;

import java.util.Objects;

public final class Version
implements Comparable<Version> {
    public final int major;
    public final int minor;
    private final transient String cachedToString;

    public Version(int major, int minor) {
        this.major = major;
        this.minor = minor;
        this.cachedToString = major + "." + minor;
    }

    public static Version LATEST_BAGIT_VERSION() {
        return new Version(1, 0);
    }

    public String toString() {
        return this.cachedToString;
    }

    @Override
    public int compareTo(Version o) {
        if (this.major > o.major || this.major == o.major && this.minor > o.minor) {
            return 1;
        }
        if (this.major == o.major && this.minor == o.minor) {
            return 0;
        }
        return -1;
    }

    public int hashCode() {
        return Objects.hash(this.major) + Objects.hash(this.minor);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Version)) {
            return false;
        }
        Version other = (Version)obj;
        return Objects.equals(this.major, other.major) && Objects.equals(this.minor, other.minor);
    }

    public boolean isNewer(Version version) {
        return this.compareTo(version) > 0;
    }

    public boolean isSameOrNewer(Version version) {
        return this.compareTo(version) >= 0;
    }

    public boolean isOlder(Version version) {
        return this.compareTo(version) < 0;
    }

    public boolean isSameOrOlder(Version version) {
        return this.compareTo(version) <= 0;
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }
}

