/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.startup;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import java.io.InputStream;
import java.util.Properties;
import org.quartz.Scheduler;
import org.quartz.impl.StdSchedulerFactory;

public class TaskScheduler {
    private static ExLogger log = ExLogger.getExLogger(TaskScheduler.class);
    private static TaskScheduler taskSchedulerInstance = null;
    private Scheduler clusteredScheduler;

    public static synchronized TaskScheduler getInstance() {
        if (taskSchedulerInstance == null) {
            taskSchedulerInstance = new TaskScheduler();
            taskSchedulerInstance.getClusterScheduler();
        }
        return taskSchedulerInstance;
    }

    public Scheduler getClusterScheduler() {
        if (this.clusteredScheduler == null) {
            try {
                Properties props = new Properties();
                InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("quartz.properties");
                props.load(inputStream);
                StdSchedulerFactory schedulerFactory = new StdSchedulerFactory(props);
                this.clusteredScheduler = schedulerFactory.getScheduler();
                this.clusteredScheduler.start();
            }
            catch (Exception e) {
                TaskScheduler.logFatalError("failed to initiate cluster scheduler", e);
            }
        }
        return this.clusteredScheduler;
    }

    public void startClusterScheduler() {
        try {
            if (!this.getClusterScheduler().isStarted()) {
                this.getClusterScheduler().start();
            }
        }
        catch (Exception e) {
            TaskScheduler.logFatalError("failed to start cluster scheduler", e);
        }
    }

    private static void logFatalError(String message, Throwable e) {
        if (e == null) {
            log.error("QUATZ_LOAD_ERROR: " + message, new String[0]);
        } else {
            log.error("QUATZ_LOAD_ERROR: " + message, e, new String[0]);
        }
    }
}

