/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api;

import com.exlibris.core.infra.common.util.IOUtil;
import com.exlibris.core.infra.svc.api.CodeTablesDescGetter;
import com.exlibris.core.infra.svc.api.ConsortiumManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.Locale;
import org.apache.commons.lang.StringEscapeUtils;

public class EmailXSLUtil {
    CodeTablesDescGetter ctDesc = new CodeTablesDescGetter();

    public String getDescription(String codeTableName, Locale locale, String code) {
        return this.ctDesc.getDescription(codeTableName, locale, code);
    }

    public String getDescription(String codeTableName, String locale, String code) {
        Locale loc = new Locale(locale);
        return this.ctDesc.getDescription(codeTableName, loc, code);
    }

    public String getDescription(String codeTableName, String locale, String code, String param1) {
        String[] params = new String[]{param1};
        return this.getDescription(codeTableName, locale, code, params);
    }

    public String getDescription(String codeTableName, String locale, String code, String param1, String param2) {
        String[] params = new String[]{param1, param2};
        return this.getDescription(codeTableName, locale, code, params);
    }

    public String getDescription(String codeTableName, String locale, String code, String param1, String param2, String param3) {
        String[] params = new String[]{param1, param2, param3};
        return this.getDescription(codeTableName, locale, code, params);
    }

    public String getDescription(String codeTableName, String locale, String code, String ... params) {
        Locale loc = new Locale(locale);
        String bundledValue = this.ctDesc.getDescription(codeTableName, loc, code);
        return MessageFormat.format(bundledValue, params);
    }

    public String getScopeDesByScopeCode(String scope) {
        ConsortiumManager consortiumManager = (ConsortiumManager)ServiceLocator.getInstance().lookUp(ConsortiumManager.class);
        return consortiumManager.getTypeByScope(scope, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getCss(String path) {
        StringBuffer sb = new StringBuffer();
        FileInputStream in = null;
        InputStreamReader isr = null;
        try {
            File imgFile = new File(path);
            in = new FileInputStream(imgFile);
            isr = new InputStreamReader(in);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
            IOUtil.closeQuietly(in);
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            IOUtil.closeQuietly(in);
            IOUtil.closeQuietly(isr);
        }
        IOUtil.closeQuietly(isr);
        return sb.toString();
    }

    public String createEmailHref(String emailAddress) {
        emailAddress = StringEscapeUtils.escapeXml((String)emailAddress);
        StringBuffer sb = new StringBuffer();
        sb.append("<a href=\"mailTo:");
        sb.append(emailAddress);
        sb.append("\">");
        sb.append(emailAddress);
        sb.append("</a>");
        return sb.toString();
    }
}

